/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.flyingblock;

import icbm.classic.config.ConfigFlyingBlocks;
import icbm.classic.config.util.BlockStateConfigListOld;
import icbm.classic.content.entity.flyingblock.BlockCaptureData;
import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class FlyingBlock {
    static final BlockStateConfigListOld banAllowList = new BlockStateConfigListOld("[Flying Blocks][Ban/Allow Config]", blockStateConfigList -> {
        blockStateConfigList.addMod("dynamictrees");
        blockStateConfigList.loadBlockStates(ConfigFlyingBlocks.banAllow.blockStates);
    });

    public static boolean isAllowed(IBlockState state) {
        if (!ConfigFlyingBlocks.enabled || state == null || state.func_177230_c().func_149688_o(state) == Material.field_151581_o || state.func_177230_c() instanceof IFluidBlock || state.func_177230_c() instanceof BlockLiquid) {
            return false;
        }
        if (ConfigFlyingBlocks.banAllow.ban) {
            return !banAllowList.contains(state);
        }
        return banAllowList.contains(state);
    }

    public static IBlockState applyMutations(IBlockState state) {
        return state;
    }

    public static boolean spawnFlyingBlock(World world, BlockPos pos, Consumer<EntityFlyingBlock> preSpawnCallback, Consumer<EntityFlyingBlock> postSpawnCallback) {
        float hardness;
        IBlockState blockState = world.func_180495_p(pos);
        if (!blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pos) && FlyingBlock.isAllowed(blockState) && (hardness = blockState.func_185887_b(world, pos)) >= 0.0f) {
            BlockCaptureData blockCaptureData = new BlockCaptureData(world, pos);
            return FlyingBlock.spawnFlyingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, blockCaptureData, preSpawnCallback, postSpawnCallback, () -> world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2));
        }
        return false;
    }

    public static boolean spawnFlyingBlock(World world, double x, double y, double z, BlockCaptureData blockCaptureData, Consumer<EntityFlyingBlock> preSpawnCallback, Consumer<EntityFlyingBlock> postSpawnCallback, Supplier<Boolean> removeBlock) {
        if (!FlyingBlock.isAllowed(blockCaptureData.getBlockState())) {
            return false;
        }
        if (removeBlock != null && !removeBlock.get().booleanValue()) {
            return false;
        }
        EntityFlyingBlock flyingBlock = new EntityFlyingBlock(world);
        flyingBlock.setBlockData(blockCaptureData);
        flyingBlock.func_70107_b(x, y, z);
        Optional.ofNullable(preSpawnCallback).ifPresent(f -> f.accept(flyingBlock));
        if (world.func_72838_d((Entity)flyingBlock)) {
            Optional.ofNullable(postSpawnCallback).ifPresent(f -> f.accept(flyingBlock));
            return true;
        }
        return false;
    }

    public static void loadFromConfig() {
        banAllowList.reload();
    }
}

