/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cluster.missile;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.cluster.missile.CapabilityClusterMissileStack;
import icbm.classic.content.cluster.missile.ClusterMissileHandler;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeCluster
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ItemStack recipeOutput;

    public boolean func_192399_d() {
        return true;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack cluster = ItemStack.field_190927_a;
        int newItemSize = 0;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            if (cluster.func_190926_b() && slotStack.func_77969_a(this.recipeOutput)) {
                cluster = slotStack;
            } else if (!ClusterMissileHandler.isAllowed(slotStack)) {
                return false;
            }
            newItemSize += ClusterMissileHandler.sizeOf(slotStack);
        }
        CapabilityClusterMissileStack cap = this.getCap(cluster);
        if (cap == null) {
            return false;
        }
        int currentSize = cap.getActionDataCluster().getClusterSpawnEntries().stream().mapToInt(ClusterMissileHandler::sizeOf).sum();
        return newItemSize >= 1 && currentSize + newItemSize <= ConfigMissile.CLUSTER_MISSILE.ITEM_SIZES.MAX_SIZE && !cluster.func_190926_b();
    }

    private CapabilityClusterMissileStack getCap(ItemStack itemStack) {
        if (!itemStack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) {
            return null;
        }
        ICapabilityMissileStack cap = (ICapabilityMissileStack)itemStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null);
        return cap instanceof CapabilityClusterMissileStack ? (CapabilityClusterMissileStack)cap : null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack cluster = ItemStack.field_190927_a;
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_77969_a(this.recipeOutput)) {
                if (!cluster.func_190926_b()) {
                    return null;
                }
                cluster = slotStack.func_77946_l();
                cluster.func_190920_e(1);
                continue;
            }
            if (slotStack.func_190926_b()) continue;
            ItemStack s = slotStack.func_77946_l();
            s.func_190920_e(1);
            newItems.add(s);
        }
        CapabilityClusterMissileStack cap = this.getCap(cluster);
        if (cap == null) {
            return null;
        }
        cap.getActionDataCluster().getClusterSpawnEntries().addAll(newItems);
        return cluster;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeCluster)) {
            return false;
        }
        RecipeCluster other = (RecipeCluster)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItemStack this$recipeOutput = this.func_77571_b();
        ItemStack other$recipeOutput = other.func_77571_b();
        return !(this$recipeOutput == null ? other$recipeOutput != null : !this$recipeOutput.equals(other$recipeOutput));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecipeCluster;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ItemStack $recipeOutput = this.func_77571_b();
        result = result * 59 + ($recipeOutput == null ? 43 : $recipeOutput.hashCode());
        return result;
    }

    @Generated
    public RecipeCluster(ItemStack recipeOutput) {
        this.recipeOutput = recipeOutput;
    }

    @Generated
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Generated
    public String toString() {
        return "RecipeCluster(recipeOutput=" + this.func_77571_b() + ")";
    }
}

