/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cluster.action;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.cause.IActionSource;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.lib.actions.ActionBase;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.transform.RotationHelper;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ActionCluster
extends ActionBase {
    private static final Vec3d SOUTH_VEC = new Vec3d(0.0, 0.0, 1.0);
    private static final Vec3d UP_VEC = new Vec3d(0.0, 1.0, 0.0);
    private static final float stackScale = 0.1f;
    private static final float offsetScale = 0.25f;
    private NonNullList<ItemStack> spawnList = NonNullList.func_191196_a();
    private boolean allowPickupItem = true;
    private float ejectionScale = 0.3f;
    private int projectilesPerLayer = 10;
    private float motionPitchOffset = -22.5f;
    private float discYawOffset = 22.5f;
    private float motionScale = 0.3f;
    private float motionScaleLayer = 0.1f;
    private float motionRandomScale = 0.1f;
    private float sourceYaw = 0.0f;
    private float sourcePitch = 0.0f;

    public ActionCluster(World world, Vec3d position, IActionSource source, IActionData actionData) {
        super(world, position, source, actionData);
    }

    @Override
    public IActionStatus doAction() {
        if (this.getWorld().field_72995_K) {
            return ActionResponses.COMPLETED;
        }
        boolean spawnedSomething = false;
        float yawAmount = 360.0f / (float)this.projectilesPerLayer;
        int bombsToFire = this.spawnList.size();
        int discIndex = 0;
        while (bombsToFire > 0) {
            for (int bombIndex = 0; bombIndex < this.projectilesPerLayer && bombsToFire > 0; ++bombIndex) {
                --bombsToFire;
                double yaw = MathHelper.func_76142_g((float)(yawAmount * (float)bombIndex + (float)discIndex * this.discYawOffset));
                Vec3d offsetYaw = RotationHelper.rotateY(SOUTH_VEC, yaw);
                Vec3d sourceVec = RotationHelper.rotateY(RotationHelper.rotateX(offsetYaw, this.sourcePitch - 90.0f), this.sourceYaw);
                Vec3d backVector = RotationHelper.rotateX(UP_VEC, this.motionPitchOffset);
                double motionX = (sourceVec.field_72450_a + backVector.field_72450_a) * (double)this.motionScale;
                double motionY = (sourceVec.field_72448_b + backVector.field_72448_b) * (double)this.motionScale;
                double motionZ = (sourceVec.field_72449_c + backVector.field_72449_c) * (double)this.motionScale;
                motionX += (sourceVec.field_72450_a + backVector.field_72450_a) * (double)this.motionScaleLayer * (double)discIndex;
                motionY += (sourceVec.field_72448_b + backVector.field_72448_b) * (double)this.motionScaleLayer * (double)discIndex;
                motionZ += (sourceVec.field_72449_c + backVector.field_72449_c) * (double)this.motionScaleLayer * (double)discIndex;
                if (this.motionRandomScale > 0.0f) {
                    motionX += (double)((this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * this.motionScaleLayer);
                    motionY += (double)((this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * this.motionScaleLayer);
                    motionZ += (double)((this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * this.motionScaleLayer);
                }
                Vec3d stackVector = RotationHelper.rotateY(RotationHelper.rotateX(SOUTH_VEC, this.sourcePitch - 180.0f), this.sourceYaw);
                double x = sourceVec.field_72450_a * 0.25 + stackVector.field_72450_a * (double)0.1f * (double)discIndex;
                double y = sourceVec.field_72448_b * 0.25 + stackVector.field_72448_b * (double)0.1f * (double)discIndex;
                double z = sourceVec.field_72449_c * 0.25 + stackVector.field_72449_c * (double)0.1f * (double)discIndex;
                spawnedSomething = this.spawnProjectile((ItemStack)this.spawnList.get(bombsToFire), x, y, z, motionX, motionY, motionZ) || spawnedSomething;
            }
            ++discIndex;
        }
        return spawnedSomething ? ActionResponses.COMPLETED : ActionResponses.ENTITY_SPAWN_FAILED;
    }

    private boolean spawnProjectile(ItemStack stackToSpawn, double x, double y, double z, double mx, double my, double mz) {
        Entity entity = ICBMClassicAPI.PROJECTILE_DATA_REGISTRY.spawnProjectile(stackToSpawn, this.getWorld(), this.getPosition().field_72450_a + x, this.getPosition().field_72448_b + y, this.getPosition().field_72449_c + z, null, this.allowPickupItem, newEntity -> {
            newEntity.func_70107_b(this.getPosition().field_72450_a + x, this.getPosition().field_72448_b + y, this.getPosition().field_72449_c + z);
            newEntity.field_70159_w = mx;
            newEntity.field_70181_x = my;
            newEntity.field_70179_y = mz;
            float f3 = MathHelper.func_76133_a((double)(newEntity.field_70159_w * newEntity.field_70159_w + newEntity.field_70179_y * newEntity.field_70179_y));
            newEntity.field_70126_B = newEntity.field_70177_z = (float)(Math.atan2(newEntity.field_70159_w, newEntity.field_70179_y) * 180.0 / Math.PI);
            newEntity.field_70127_C = newEntity.field_70125_A = (float)(Math.atan2(newEntity.field_70181_x, f3) * 180.0 / Math.PI);
        });
        if (entity == null) {
            EntityItem entityItem = new EntityItem(this.getWorld());
            entityItem.func_70107_b(this.getPosition().field_72450_a + x, this.getPosition().field_72448_b + y, this.getPosition().field_72449_c + z);
            entityItem.func_92058_a(stackToSpawn.func_77946_l());
            entityItem.func_174869_p();
            entityItem.field_70159_w = mx;
            entityItem.field_70181_x = my;
            entityItem.field_70179_y = mz;
            float f3 = MathHelper.func_76133_a((double)(entityItem.field_70159_w * entityItem.field_70159_w + entityItem.field_70179_y * entityItem.field_70179_y));
            entityItem.field_70126_B = entityItem.field_70177_z = (float)(Math.atan2(entityItem.field_70159_w, entityItem.field_70179_y) * 180.0 / Math.PI);
            entityItem.field_70127_C = entityItem.field_70125_A = (float)(Math.atan2(entityItem.field_70181_x, f3) * 180.0 / Math.PI);
            return this.getWorld().func_72838_d((Entity)entityItem);
        }
        return true;
    }

    @Generated
    public NonNullList<ItemStack> getSpawnList() {
        return this.spawnList;
    }

    @Generated
    public void setSpawnList(NonNullList<ItemStack> spawnList) {
        this.spawnList = spawnList;
    }

    @Generated
    public boolean isAllowPickupItem() {
        return this.allowPickupItem;
    }

    @Generated
    public void setAllowPickupItem(boolean allowPickupItem) {
        this.allowPickupItem = allowPickupItem;
    }

    @Generated
    public float getEjectionScale() {
        return this.ejectionScale;
    }

    @Generated
    public void setEjectionScale(float ejectionScale) {
        this.ejectionScale = ejectionScale;
    }

    @Generated
    public int getProjectilesPerLayer() {
        return this.projectilesPerLayer;
    }

    @Generated
    public void setProjectilesPerLayer(int projectilesPerLayer) {
        this.projectilesPerLayer = projectilesPerLayer;
    }

    @Generated
    public float getMotionPitchOffset() {
        return this.motionPitchOffset;
    }

    @Generated
    public void setMotionPitchOffset(float motionPitchOffset) {
        this.motionPitchOffset = motionPitchOffset;
    }

    @Generated
    public float getDiscYawOffset() {
        return this.discYawOffset;
    }

    @Generated
    public void setDiscYawOffset(float discYawOffset) {
        this.discYawOffset = discYawOffset;
    }

    @Generated
    public float getMotionScale() {
        return this.motionScale;
    }

    @Generated
    public void setMotionScale(float motionScale) {
        this.motionScale = motionScale;
    }

    @Generated
    public float getMotionScaleLayer() {
        return this.motionScaleLayer;
    }

    @Generated
    public void setMotionScaleLayer(float motionScaleLayer) {
        this.motionScaleLayer = motionScaleLayer;
    }

    @Generated
    public float getMotionRandomScale() {
        return this.motionRandomScale;
    }

    @Generated
    public void setMotionRandomScale(float motionRandomScale) {
        this.motionRandomScale = motionRandomScale;
    }

    @Generated
    public float getSourceYaw() {
        return this.sourceYaw;
    }

    @Generated
    public void setSourceYaw(float sourceYaw) {
        this.sourceYaw = sourceYaw;
    }

    @Generated
    public float getSourcePitch() {
        return this.sourcePitch;
    }

    @Generated
    public void setSourcePitch(float sourcePitch) {
        this.sourcePitch = sourcePitch;
    }
}

