/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.radarstation.gui;

import icbm.classic.content.blocks.radarstation.TileRadarStation;
import icbm.classic.content.blocks.radarstation.data.RadarDotType;
import icbm.classic.content.blocks.radarstation.data.RadarRenderDot;
import icbm.classic.lib.colors.ColorHelper;
import icbm.classic.prefab.gui.GuiContainerBase;
import icbm.classic.prefab.gui.IGuiComponent;
import java.util.List;
import net.minecraft.client.gui.Gui;

public class RadarComponent
implements IGuiComponent {
    final int MARKER_COLOR = ColorHelper.toARGB(0, 255, 0, 255);
    final int HOSTILE_COLOR = ColorHelper.toARGB(255, 255, 0, 255);
    final int INCOMING_COLOR = ColorHelper.toARGB(255, 0, 0, 255);
    final int TRIGGER_RANGE = ColorHelper.toARGB(255, 0, 255, 255);
    private final TileRadarStation tile;
    private final int x;
    private final int y;
    private GuiContainerBase container;
    int meterSpacing = 0;

    public RadarComponent(TileRadarStation tile, int x, int y) {
        this.tile = tile;
        this.x = x;
        this.y = y;
    }

    @Override
    public void onAddedToHost(GuiContainerBase container) {
        this.container = container;
    }

    @Override
    public void onUpdate() {
        this.meterSpacing = (int)Math.floor((float)this.tile.getDetectionRange() / 100.0f * 40.0f);
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY) {
        List<RadarRenderDot> dots = this.tile.getRadarRenderData().getDots();
        this.container.func_73731_b(this.container.field_146297_k.field_71466_p, String.format("%dm", this.meterSpacing), this.x + 56, this.y + 46, this.MARKER_COLOR);
        this.container.func_73731_b(this.container.field_146297_k.field_71466_p, String.format("%d", dots.stream().filter(d -> d.getType() == RadarDotType.HOSTILE).count()), this.x + 56, this.y + 2, this.HOSTILE_COLOR);
        this.container.func_73731_b(this.container.field_146297_k.field_71466_p, String.format("%d", dots.stream().filter(d -> d.getType() == RadarDotType.INCOMING).count()), this.x + 56, this.y + 14, this.INCOMING_COLOR);
    }

    @Override
    public void drawBackgroundLayer(float f, int mouseX, int mouseY) {
        int i;
        int halfUV = 27;
        int left = this.container.getGuiLeft() + this.x;
        int top = this.container.getGuiTop() + this.y;
        Gui.func_73734_a((int)left, (int)top, (int)(left + 54 + 1), (int)(top + 54 + 1), (int)-16777216);
        int gx = left + 27;
        int gy = top + 27;
        int lineCount = (int)Math.floor((float)this.tile.getDetectionRange() / (float)this.meterSpacing) * 2 + 1;
        float lineSpacing = (float)this.meterSpacing / (float)this.tile.getDetectionRange() * 27.0f;
        int lx = gx - (int)((float)(lineCount / 2) * lineSpacing);
        int ly = gy - (int)((float)(lineCount / 2) * lineSpacing);
        for (i = 0; i < lineCount; ++i) {
            int x = lx + (int)Math.floor((float)i * lineSpacing);
            Gui.func_73734_a((int)x, (int)(gy + 27), (int)(x + 1), (int)(gy - 27), (int)this.MARKER_COLOR);
        }
        for (i = 0; i < lineCount; ++i) {
            int y = ly + (int)Math.floor((float)i * lineSpacing);
            Gui.func_73734_a((int)(gx + 27), (int)y, (int)(gx - 27), (int)(y + 1), (int)this.MARKER_COLOR);
        }
        int triggerRange = (int)Math.ceil((float)this.tile.getTriggerRange() / (float)this.tile.getDetectionRange() * 27.0f);
        Gui.func_73734_a((int)(gx - triggerRange), (int)(gy + triggerRange), (int)(gx + triggerRange), (int)(gy + triggerRange + 1), (int)this.TRIGGER_RANGE);
        Gui.func_73734_a((int)(gx - triggerRange), (int)(gy - triggerRange - 1), (int)(gx + triggerRange), (int)(gy - triggerRange), (int)this.TRIGGER_RANGE);
        Gui.func_73734_a((int)(gx - triggerRange - 1), (int)(gy - triggerRange), (int)(gx - triggerRange), (int)(gy + triggerRange), (int)this.TRIGGER_RANGE);
        Gui.func_73734_a((int)(gx + triggerRange), (int)(gy - triggerRange), (int)(gx + triggerRange + 1), (int)(gy + triggerRange), (int)this.TRIGGER_RANGE);
        for (int i2 = 0; i2 < this.tile.getRadarRenderData().getDots().size(); ++i2) {
            RadarRenderDot dot = this.tile.getRadarRenderData().getDots().get(i2);
            int x = gx + dot.getX();
            int y = gy + dot.getY();
            if (dot.getType() == RadarDotType.MARKER) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)this.MARKER_COLOR);
                continue;
            }
            if (dot.getType() == RadarDotType.HOSTILE) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + 2), (int)(y + 2), (int)this.HOSTILE_COLOR);
                continue;
            }
            if (dot.getType() != RadarDotType.INCOMING) continue;
            Gui.func_73734_a((int)x, (int)y, (int)(x + 2), (int)(y + 2), (int)this.INCOMING_COLOR);
        }
    }
}

