/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.connector;

import icbm.classic.ICBMClassic;
import icbm.classic.content.blocks.launcher.connector.TileLauncherConnector;
import icbm.classic.content.blocks.launcher.frame.TileLauncherFrame;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherNetwork;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockLaunchConnector
extends BlockContainer {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockLaunchConnector() {
        super(Material.field_151573_f);
        this.field_149782_v = 10.0f;
        this.field_149781_w = 10.0f;
        this.setRegistryName("icbmclassic", "launcher_connector");
        this.func_149663_c("icbmclassic:launcher_connector");
        this.func_149647_a(ICBMClassic.CREATIVE_TAB);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean upConnection = this.isConnection(worldIn, pos, EnumFacing.UP);
        boolean downConnection = this.isConnection(worldIn, pos, EnumFacing.DOWN);
        boolean northConnection = this.isConnection(worldIn, pos, EnumFacing.NORTH);
        boolean eastConnection = this.isConnection(worldIn, pos, EnumFacing.EAST);
        boolean southConnection = this.isConnection(worldIn, pos, EnumFacing.SOUTH);
        boolean westConnection = this.isConnection(worldIn, pos, EnumFacing.WEST);
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(upConnection)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(downConnection)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(northConnection)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(eastConnection)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(southConnection)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(westConnection));
    }

    private boolean isConnection(IBlockAccess worldIn, BlockPos selfPos, EnumFacing side) {
        BlockPos pos = selfPos.func_177972_a(side);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null) {
            return tile.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d()) || tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileLauncherFrame && playerIn.func_184586_b(hand).func_77973_b() == Items.field_151049_t) {
            if (!worldIn.field_72995_K) {
                LauncherNetwork network = ((TileLauncherFrame)tile).getNetworkNode().getNetwork();
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Network: " + network));
                playerIn.func_145747_a((ITextComponent)new TextComponentString("L: " + network.getLaunchers().size()));
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, EAST, WEST, SOUTH});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileLauncherConnector();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ILauncherComponent) {
            ((ILauncherComponent)tile).getNetworkNode().onTileRemoved();
        }
        super.func_180663_b(world, pos, state);
    }
}

