/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.base;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.events.LauncherEvent;
import icbm.classic.api.launcher.ILauncherSolution;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.missiles.parts.IMissileTargetDelayed;
import icbm.classic.config.machines.ConfigLauncher;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.LauncherBaseCapability;
import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.content.blocks.launcher.status.FiringWithDelay;
import icbm.classic.content.blocks.launcher.status.LaunchedWithMissile;
import icbm.classic.content.blocks.launcher.status.LauncherStatus;
import icbm.classic.content.missile.logic.flight.ArcFlightLogic;
import icbm.classic.content.missile.logic.flight.WarmupFlightLogic;
import icbm.classic.content.missile.logic.flight.move.MoveByFacingLogic;
import icbm.classic.content.missile.logic.flight.prefab.AccelerateByFacingLogic;
import icbm.classic.content.missile.logic.source.ActionSource;
import icbm.classic.content.missile.logic.source.cause.CausedByBlock;
import icbm.classic.content.missile.logic.targeting.BallisticTargetingData;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.transform.rotation.EulerAngle;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LauncherCapability
extends LauncherBaseCapability {
    public static final int PAD_WARM_UP_TIME = 40;
    public static final double MISSILE_CLIMB_HEIGHT = 2.0;
    private static final EulerAngle angle = new EulerAngle(0.0, 0.0, 0.0);
    private static final Vec3d[] SPAWN_OFFSETS = new Vec3d[]{new Vec3d(0.0, (double)-3.1f, 0.0), new Vec3d(0.0, (double)2.6f, 0.0), new Vec3d(0.0, (double)-0.2f, (double)-2.8f), new Vec3d(0.0, (double)-0.2f, (double)2.8f), new Vec3d((double)-2.8f, (double)-0.2f, 0.0), new Vec3d((double)2.8f, (double)-0.2f, 0.0)};
    private final TileLauncherBase host;

    @Override
    public IActionStatus getStatus() {
        if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
            return LauncherStatus.ERROR_POWER;
        }
        if (this.host.missileHolder.getMissileStack().func_190926_b()) {
            return LauncherStatus.ERROR_EMPTY_STACK;
        }
        if (this.host.getFiringPackage() != null && this.host.getFiringPackage().getCountDown() > 0) {
            return new FiringWithDelay(this.host.getFiringPackage().getCountDown());
        }
        return LauncherStatus.READY;
    }

    @Override
    public IActionStatus preCheckLaunch(IMissileTarget targetData, @Nullable IActionCause cause) {
        if (targetData == null || targetData.getPosition() == null) {
            return LauncherStatus.ERROR_TARGET_NULL;
        }
        if (this.isTargetTooClose(targetData.getPosition())) {
            return LauncherStatus.ERROR_MIN_RANGE;
        }
        if (this.isTargetTooFar(targetData.getPosition())) {
            return LauncherStatus.ERROR_MAX_RANGE;
        }
        return this.getStatus();
    }

    @Override
    public IActionStatus launch(ILauncherSolution solution, @Nullable IActionCause cause, boolean simulate) {
        ICapabilityMissileStack missileStack;
        IMissileTarget targetData = solution.getTarget(this);
        IActionStatus preCheck = this.preCheckLaunch(targetData, cause);
        if (preCheck.isBlocking()) {
            return preCheck;
        }
        CausedByBlock selfCause = new CausedByBlock(this.host.func_145831_w(), this.host.func_174877_v(), this.host.getBlockState());
        selfCause.setPreviousCause(cause);
        Vec3d spawnPosition = SPAWN_OFFSETS[this.host.getLaunchDirection().ordinal()].func_72441_c((double)this.host.func_174877_v().func_177958_n() + 0.5, (double)this.host.func_174877_v().func_177956_o() + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5);
        ActionSource source = new ActionSource(this.host.func_145831_w(), spawnPosition, selfCause);
        LauncherEvent.PreLaunch event = new LauncherEvent.PreLaunch(source, this, this.host.missileHolder, targetData, simulate);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (event.cancelReason != null) {
                return event.cancelReason;
            }
            return LauncherStatus.CANCELED;
        }
        ItemStack stack = this.host.missileHolder.getMissileStack();
        if (stack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null) && (missileStack = (ICapabilityMissileStack)stack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) != null) {
            Vec3d target = this.applyInaccuracy(targetData.getPosition(), Math.max(1, solution.getFiringCount()));
            if (this.host.getFiringPackage() == null) {
                int delay = this.host.getFiringDelay();
                if (targetData instanceof IMissileTargetDelayed) {
                    delay += ((IMissileTargetDelayed)targetData).getFiringDelay();
                }
                if (delay > 0) {
                    if (!simulate) {
                        this.host.setFiringPackage(new FiringPackage(targetData, cause, delay));
                    }
                    return new FiringWithDelay(delay);
                }
            }
            if (!this.getHost().isServer() || simulate) {
                return LauncherStatus.LAUNCHED;
            }
            IMissile missile = missileStack.newMissile(this.host.func_145831_w());
            return this.fireMissile(missile, source, target);
        }
        return LauncherStatus.ERROR_INVALID_STACK;
    }

    private IActionStatus fireMissile(IMissile missile, ActionSource source, Vec3d target) {
        if (!this.host.missileHolder.consumeMissile()) {
            return LauncherStatus.ERROR_INVALID_STACK;
        }
        Entity entity = missile.getMissileEntity();
        entity.field_70125_A = entity.field_70127_C = this.host.getMissilePitch(false);
        entity.field_70177_z = entity.field_70126_B = this.host.getMissileYaw(false);
        entity.func_70107_b(source.getPosition().field_72450_a, source.getPosition().field_72448_b, source.getPosition().field_72449_c);
        missile.setTargetData(new BallisticTargetingData(target, 2));
        missile.setFlightLogic(this.buildFLightPath());
        missile.setMissileSource(source);
        missile.launch();
        if (!this.host.func_145831_w().func_72838_d(entity)) {
            return LauncherStatus.ERROR_SPAWN;
        }
        if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
            return LauncherStatus.ERROR_POWER;
        }
        this.host.energyStorage.consumePower(this.host.getFiringCost(), false);
        if (this.host.seat != null && !this.host.seat.func_184188_bt().isEmpty()) {
            List riders = this.host.seat.func_184188_bt();
            riders.forEach(r -> {
                entity.func_184210_p();
                r.func_184220_m(entity);
            });
        }
        return new LaunchedWithMissile().setMissile(missile);
    }

    public IMissileFlightLogic buildFLightPath() {
        if (this.host.getLaunchDirection() != EnumFacing.UP) {
            AccelerateByFacingLogic stepLockHeight = new MoveByFacingLogic().setDistance(this.host.getLockHeight()).setRelative(false).setDirection(this.host.getLaunchDirection()).setAcceleration(0.2);
            ArcFlightLogic arcFlight = new ArcFlightLogic();
            return new WarmupFlightLogic().setTimer(40).addStep(stepLockHeight).addStep(arcFlight);
        }
        AccelerateByFacingLogic stepSlowClimb = new MoveByFacingLogic().setDistance(2.0).setRelative(false).setDirection(this.host.getLaunchDirection()).setAcceleration(0.005);
        AccelerateByFacingLogic stepLockHeight = new MoveByFacingLogic().setDistance((double)this.host.getLockHeight() - 2.0).setRelative(false).setDirection(this.host.getLaunchDirection()).setAcceleration(0.1);
        ArcFlightLogic arcFlight = new ArcFlightLogic();
        return new WarmupFlightLogic().setTimer(40).addStep(stepSlowClimb).addStep(stepLockHeight).addStep(arcFlight);
    }

    @Override
    public float getInaccuracy(Vec3d target, int launcherCount) {
        double distance = this.host.func_145835_a(target.field_72450_a, target.field_72448_b, target.field_72449_c);
        return LauncherCapability.calculateInaccuracy(distance, launcherCount);
    }

    public static float calculateInaccuracy(double distanceSq, int missiles) {
        float inaccuracy = (float)ConfigLauncher.MIN_INACCURACY;
        double scale = distanceSq / (double)(ConfigLauncher.RANGE * ConfigLauncher.RANGE);
        inaccuracy += (float)(scale * ConfigLauncher.SCALED_INACCURACY_DISTANCE);
        if (missiles > 1) {
            inaccuracy += (float)((double)(missiles - 1) * ConfigLauncher.SCALED_INACCURACY_LAUNCHERS);
        }
        return inaccuracy;
    }

    protected Vec3d applyInaccuracy(Vec3d target, int launcherCount) {
        float inaccuracy = this.getInaccuracy(target, launcherCount) * this.host.func_145831_w().field_73012_v.nextFloat();
        angle.setYaw(this.host.func_145831_w().field_73012_v.nextFloat() * 360.0f);
        return new Vec3d(target.field_72450_a + angle.x() * (double)inaccuracy, target.field_72448_b, target.field_72449_c + angle.z() * (double)inaccuracy);
    }

    public boolean isTargetTooClose(Vec3d target) {
        int minDistance = 10;
        double deltaX = Math.abs(target.field_72450_a - ((double)this.host.func_174877_v().func_177958_n() + 0.5));
        double deltaZ = Math.abs(target.field_72449_c - ((double)this.host.func_174877_v().func_177952_p() + 0.5));
        return deltaX < 10.0 && deltaZ < 10.0;
    }

    public boolean isTargetTooFar(Vec3d target) {
        double deltaX = Math.abs(target.field_72450_a - ((double)this.host.func_174877_v().func_177958_n() + 0.5));
        double deltaZ = Math.abs(target.field_72449_c - ((double)this.host.func_174877_v().func_177952_p() + 0.5));
        return deltaX > (double)ConfigLauncher.RANGE || deltaZ > (double)ConfigLauncher.RANGE;
    }

    @Override
    public float getPayloadVelocity() {
        return this.host.missileHolder.getMissileStack().func_77973_b() == ItemReg.itemSAM ? ConfigMissile.SAM_MISSILE.FLIGHT_SPEED : ConfigMissile.DIRECT_FLIGHT_SPEED;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LauncherCapability)) {
            return false;
        }
        LauncherCapability other = (LauncherCapability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TileLauncherBase this$host = this.getHost();
        TileLauncherBase other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LauncherCapability;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TileLauncherBase $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public TileLauncherBase getHost() {
        return this.host;
    }

    @Generated
    public String toString() {
        return "LauncherCapability(host=" + this.getHost() + ")";
    }

    @Generated
    public LauncherCapability(TileLauncherBase host) {
        this.host = host;
    }
}

