/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.emptower;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.radio.IRadioMessage;
import icbm.classic.api.radio.IRadioReceiver;
import icbm.classic.api.radio.IRadioSender;
import icbm.classic.api.radio.messages.ITriggerActionMessage;
import icbm.classic.content.blocks.emptower.TileEMPTower;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.lib.radio.imp.RadioTile;
import icbm.classic.lib.radio.messages.IncomingMissileMessage;
import icbm.classic.lib.radio.messages.TextMessage;
import icbm.classic.prefab.FakeRadioSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class RadioEmpTower
extends RadioTile<TileEMPTower>
implements IRadioReceiver,
INBTSerializable<NBTTagCompound> {
    public static final String SUCCESS = "tile.emptower.radio.success";

    public RadioEmpTower(TileEMPTower host) {
        super(host);
    }

    @Override
    public void onMessage(IRadioSender sender, IRadioMessage packet) {
        if (this.canReceive(sender, packet)) {
            EntityCause cause = null;
            if (sender instanceof FakeRadioSender) {
                cause = new EntityCause((Entity)((FakeRadioSender)sender).player);
            }
            if (packet instanceof IncomingMissileMessage && ((IncomingMissileMessage)packet).shouldTrigger()) {
                IMissile missile = ((IncomingMissileMessage)packet).getMissile();
                double distance = Math.sqrt(((TileEMPTower)this.host).func_145835_a(missile.x(), missile.y(), missile.z()));
                if (distance < (double)((TileEMPTower)this.host).getRange() && ((TileEMPTower)this.host).fire(cause)) {
                    sender.onMessageCallback(this, new TextMessage(this.getChannel(), SUCCESS));
                }
            } else if (packet instanceof ITriggerActionMessage && ((ITriggerActionMessage)packet).shouldTrigger() && ((TileEMPTower)this.host).fire(cause)) {
                sender.onMessageCallback(this, new TextMessage(this.getChannel(), SUCCESS));
            }
        }
    }
}

