/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.imp;

import icbm.classic.api.actions.cause.IActionSource;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.lib.actions.status.ActionResponses;
import javax.annotation.Nonnull;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class BlastBase
implements IBlastInit {
    private World world;
    private double x;
    private double y;
    private double z;
    private boolean locked;
    @Deprecated
    private double blastSize;
    private IExplosiveData explosiveData;
    private IActionSource actionSource;

    protected abstract IActionStatus triggerBlast();

    @Override
    public void clearBlast() {
    }

    @Override
    @Nonnull
    public IActionStatus doAction() {
        World world = this.world();
        if (world != null) {
            if (!world.field_72995_K) {
                return this.triggerBlast();
            }
            return ActionResponses.COMPLETED;
        }
        return ActionResponses.MISSING_WORLD;
    }

    @Override
    public float getBlastRadius() {
        return (float)Math.min(this.blastSize, 1.0);
    }

    @Override
    @Nonnull
    public IActionSource getSource() {
        return this.actionSource;
    }

    @Override
    @Nonnull
    public IExplosiveData getActionData() {
        return this.explosiveData;
    }

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public Vec3d getPosition() {
        return new Vec3d(this.x, this.y, this.z);
    }

    @Override
    public IBlastInit setBlastSize(double size) {
        if (!this.locked) {
            this.blastSize = size;
        }
        return this;
    }

    @Override
    public IBlastInit setBlastWorld(World world) {
        if (!this.locked) {
            this.world = world;
        }
        return this;
    }

    @Override
    public IBlastInit setBlastPosition(double x, double y, double z) {
        if (!this.locked) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
        return this;
    }

    @Override
    public IBlastInit setActionSource(IActionSource source) {
        if (!this.locked) {
            this.actionSource = source;
        }
        return this;
    }

    @Override
    public IBlastInit setExplosiveData(IExplosiveData data) {
        if (!this.locked) {
            this.explosiveData = data;
        }
        return this;
    }

    @Override
    public IBlastInit buildBlast() {
        this.locked = true;
        return this;
    }
}

