/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.api.data.Int3Consumer;
import icbm.classic.api.data.Int3Looper;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;

public final class BlastHelpers {
    private BlastHelpers() {
    }

    public static void forEachPosInRadius(double radius, Int3Consumer consumer) {
        BlastHelpers.forEachPosInRadiusUntil(radius, (x, y, z) -> {
            consumer.apply(x, y, z);
            return true;
        }, () -> false);
    }

    public static void forEachPosInRadiusUntil(double radius, Int3Looper consumer, BooleanSupplier stopper) {
        int size = (int)Math.ceil(radius);
        BlastHelpers.forEachPosInCube(size, size, size, (x, y, z) -> {
            if (stopper.getAsBoolean()) {
                return false;
            }
            double distanceSQ = x * x + y * y + z * z;
            double radiusSQ = radius * radius;
            if (distanceSQ <= radiusSQ) {
                return consumer.apply(x, y, z);
            }
            return true;
        });
    }

    public static void forEachPosInCube(int xSize, int ySize, int zSize, @Nonnull Int3Looper consumer) {
        for (int x = -xSize; x <= xSize; ++x) {
            for (int y = -ySize; y <= ySize; ++y) {
                for (int z = -zSize; z <= zSize; ++z) {
                    if (consumer.apply(x, y, z)) continue;
                    return;
                }
            }
        }
    }
}

