/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.client.ICBMSounds;
import icbm.classic.content.blast.Blast;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;

public class BlastFire
extends Blast {
    @Override
    public boolean doExplode(int callCount) {
        if (!this.world().field_72995_K) {
            int radius = (int)this.getBlastRadius();
            for (int x = 0; x < radius; ++x) {
                for (int y = 0; y < radius; ++y) {
                    for (int z = 0; z < radius; ++z) {
                        if (x != 0 && x != radius - 1 && y != 0 && y != radius - 1 && z != 0 && z != radius - 1) continue;
                        double xStep = (float)x / ((float)radius - 1.0f) * 2.0f - 1.0f;
                        double yStep = (float)y / ((float)radius - 1.0f) * 2.0f - 1.0f;
                        double zStep = (float)z / ((float)radius - 1.0f) * 2.0f - 1.0f;
                        double diagonalDistance = Math.sqrt(xStep * xStep + yStep * yStep + zStep * zStep);
                        xStep /= diagonalDistance;
                        yStep /= diagonalDistance;
                        zStep /= diagonalDistance;
                        double posX = this.location.x();
                        double posY = this.location.y();
                        double posZ = this.location.z();
                        float stepAmount = 0.3f;
                        for (float energy = (float)radius * (0.7f + this.world().field_73012_v.nextFloat() * 0.6f); energy > 0.0f; energy -= stepAmount * 0.75f) {
                            double chance;
                            BlockPos targetPosition = new BlockPos(posX, posY, posZ);
                            double distanceFromCenter = this.location.distance((Vec3i)targetPosition);
                            IBlockState blockState = this.world().func_180495_p(targetPosition);
                            Block block = blockState.func_177230_c();
                            if (!block.isAir(blockState, (IBlockAccess)this.field_77287_j, targetPosition)) {
                                energy -= (block.getExplosionResistance(this.world(), targetPosition, this.field_77283_e, (Explosion)this) + 0.3f) * stepAmount;
                            }
                            if (energy > 0.0f && (chance = (double)radius - Math.random() * distanceFromCenter) > distanceFromCenter * 0.55) {
                                boolean canReplace;
                                boolean bl = canReplace = block.func_176200_f((IBlockAccess)this.world(), targetPosition) || block.isAir(blockState, (IBlockAccess)this.world(), targetPosition);
                                if (canReplace && Blocks.field_150480_ab.func_176196_c(this.world(), targetPosition)) {
                                    this.field_77287_j.func_180501_a(targetPosition, Blocks.field_150480_ab.func_176223_P(), 3);
                                } else if (block == Blocks.field_150432_aD) {
                                    this.field_77287_j.func_175698_g(targetPosition);
                                }
                            }
                            posX += xStep * (double)stepAmount;
                            posY += yStep * (double)stepAmount;
                            posZ += zStep * (double)stepAmount;
                        }
                    }
                }
            }
        }
        ICBMSounds.EXPLOSION_FIRE.play(this.field_77287_j, this.location.x() + 0.5, this.location.y() + 0.5, this.location.z() + 0.5, 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
        return true;
    }
}

