/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.content.blast.BlastHelpers;
import icbm.classic.content.blast.thread.ThreadSmallExplosion;
import icbm.classic.content.blast.threaded.BlastThreaded;
import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import icbm.classic.content.entity.flyingblock.FlyingBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class BlastAntiGravitational
extends BlastThreaded
implements IBlastTickable {
    public static final int RUNNING_TICKS = 2400;
    protected ThreadSmallExplosion thread;
    protected Set<EntityFlyingBlock> flyingBlocks = new HashSet<EntityFlyingBlock>();
    List<BlockPos> results;
    int searchIndex = 0;

    @Override
    public boolean setupBlast() {
        if (!this.world().field_72995_K) {
            this.thread = new ThreadSmallExplosion(this, (int)this.getBlastRadius(), this.field_77283_e);
            this.thread.start();
        }
        return true;
    }

    @Override
    public boolean doRun(int loops, Consumer<BlockPos> edits) {
        BlastHelpers.forEachPosInRadius(this.getBlastRadius(), (x, y, z) -> edits.accept(new BlockPos(this.xi() + x, this.yi() + y, this.zi() + z)));
        return false;
    }

    @Override
    public boolean doExplode(int callCount) {
        if (this.world() != null && !this.world().field_72995_K) {
            if (this.thread != null) {
                if (this.thread.isComplete) {
                    BlockPos targetPosition;
                    if (this.results == null) {
                        this.results = new ArrayList<BlockPos>(this.getThreadResults());
                        Collections.shuffle(this.results);
                        this.results.sort(Comparator.comparingInt(r -> -r.func_177956_o()));
                        this.threadResults.clear();
                    }
                    if (this.searchIndex >= this.results.size()) {
                        this.searchIndex = 0;
                    }
                    while (this.searchIndex < this.results.size() && !FlyingBlock.spawnFlyingBlock(this.field_77287_j, targetPosition = this.results.get(this.searchIndex), entity -> {
                        entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                        entity.pitchChange = 100.0f * this.world().field_73012_v.nextFloat();
                        entity.field_70181_x += (double)Math.max(1.0f * this.world().field_73012_v.nextFloat(), 1.0f);
                        double deltaX = (double)targetPosition.func_177958_n() - this.location.func_82615_a();
                        double deltaZ = (double)targetPosition.func_177952_p() - this.location.func_82616_c();
                        double mag = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                        entity.field_70159_w += (deltaX /= mag) * (double)(1.0f - this.world().field_73012_v.nextFloat());
                        entity.field_70179_y += (deltaZ /= mag) * (double)(1.0f - this.world().field_73012_v.nextFloat());
                        entity.setGravity(0.0f);
                        entity.setInAirKillTime(4800);
                    }, entityFlyingBlock -> this.flyingBlocks.add((EntityFlyingBlock)entityFlyingBlock))) {
                        ++this.searchIndex;
                    }
                }
            } else {
                String msg = String.format("BlastAntiGravitational#doPostExplode() -> Failed to run due to null thread\nWorld = %s \nThread = %s\nSize = %s\nPos = ", this.field_77287_j, this.thread, Float.valueOf(this.field_77280_f), this.location);
                ICBMClassic.logger().error(msg);
            }
        }
        int radius = (int)this.getBlastRadius();
        int affectHeight = Math.max(radius, 100);
        AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)radius, this.location.y() - (double)radius, this.location.z() - (double)radius, this.location.y() + (double)radius, this.location.y() + (double)affectHeight, this.location.z() + (double)radius);
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        for (Entity entity2 : allEntities) {
            if (!(entity2.field_70163_u < (double)affectHeight + this.location.y()) || !(entity2.field_70181_x < 0.4)) continue;
            entity2.field_70181_x += 0.15;
        }
        return this.callCount > 2400;
    }

    @Override
    protected void onBlastCompleted() {
        this.flyingBlocks.forEach(EntityFlyingBlock::restoreGravity);
    }
}

