/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.actions.conditionals;

import icbm.classic.api.actions.conditions.ICondition;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.api.actions.data.IActionFieldProvider;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.actions.status.MissingFieldStatus;
import icbm.classic.lib.saving.NbtSaveHandler;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class ConditionalImpact
implements ICondition,
INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "impact");
    private IActionFieldProvider provider;
    private boolean impactDesired = true;
    private static final NbtSaveHandler<ConditionalImpact> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeBoolean("impact_desired", ConditionalImpact::isImpactDesired, ConditionalImpact::setImpactDesired).base();

    @Override
    public void init(IActionFieldProvider provider) {
        this.provider = provider;
    }

    @Override
    public IActionStatus getCondition() {
        if (this.provider == null || !this.provider.hasField(ActionFields.IMPACTED)) {
            return new MissingFieldStatus().setSource("ConditionalImpact#provider").setField(ActionFields.IMPACTED.getKey());
        }
        Boolean value = this.provider.getValue(ActionFields.IMPACTED);
        if (value == null || value != this.impactDesired) {
            return ActionResponses.WAITING;
        }
        return ActionResponses.READY;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public boolean isImpactDesired() {
        return this.impactDesired;
    }

    @Generated
    public ConditionalImpact setImpactDesired(boolean impactDesired) {
        this.impactDesired = impactDesired;
        return this;
    }
}

