/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.actions.conditionals;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.conditions.ICondition;
import icbm.classic.api.actions.conditions.IConditionCause;
import icbm.classic.api.actions.conditions.IConditionLayer;
import icbm.classic.api.actions.status.ActionStatusTypes;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class ConditionAnd
implements IConditionLayer,
IConditionCause,
INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "composition.and");
    private final List<ICondition> children = new ArrayList<ICondition>();
    private boolean shortCircuit = true;
    private static final NbtSaveHandler<ConditionAnd> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeBuildableObjectList("conditions", () -> ICBMClassicAPI.CONDITION_REGISTRY, ConditionAnd::getConditions).nodeBoolean("short_circuit", ConditionAnd::isShortCircuit, ConditionAnd::setShortCircuit).base();

    @Override
    public IActionStatus getCondition() {
        for (ICondition condition : this.children) {
            IActionStatus status = condition.getCondition();
            if (!status.isType(ActionStatusTypes.BLOCKING)) continue;
            return status;
        }
        return ActionResponses.READY;
    }

    @Override
    public void onTick() {
        for (ICondition condition : this.children) {
            condition.onTick();
            IActionStatus status = condition.getCondition();
            if (!this.shortCircuit || !status.isType(ActionStatusTypes.BLOCKING)) continue;
            return;
        }
    }

    @Override
    public List<ICondition> getConditions() {
        return this.children;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    @Override
    public IActionCause getCause() {
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    @Generated
    public ConditionAnd setShortCircuit(boolean shortCircuit) {
        this.shortCircuit = shortCircuit;
        return this;
    }
}

