/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.actions;

import icbm.classic.api.actions.IAction;
import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.cause.IActionSource;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.lib.actions.ActionBase;
import icbm.classic.lib.actions.status.ActionResponses;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ActionUpdateBlockState
extends ActionBase
implements IAction {
    private final Function<IBlockState, Boolean> validation;
    private final Function<IBlockState, IBlockState> modifyBlock;

    public ActionUpdateBlockState(World world, BlockPos pos, Function<IBlockState, Boolean> validation, Function<IBlockState, IBlockState> modifyBlock, IActionSource source, IActionData actionData) {
        super(world, new Vec3d((Vec3i)pos), source, actionData);
        this.validation = validation;
        this.modifyBlock = modifyBlock;
    }

    @Override
    @Nonnull
    public IActionStatus doAction() {
        if (this.modifyBlock == null) {
            return ActionResponses.MISSING_BLOCK_STATE;
        }
        if (this.validation == null) {
            return ActionResponses.MISSING_VALIDATION;
        }
        BlockPos pos = this.getBlockPos();
        IBlockState currentState = this.getWorld().func_180495_p(pos);
        if (this.validation.apply(currentState).booleanValue()) {
            IBlockState newState = this.modifyBlock.apply(currentState);
            if (newState != currentState && !this.getWorld().func_175656_a(pos, newState)) {
                return ActionResponses.BLOCK_PLACEMENT_FAILED;
            }
            return ActionResponses.COMPLETED;
        }
        return ActionResponses.VALIDATION_ERROR;
    }
}

