/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config.util;

import com.google.common.collect.ImmutableMap;
import icbm.classic.config.util.ResourceConfigEntry;
import icbm.classic.config.util.ResourceConfigList;
import icbm.classic.lib.ForgeRegistryHelpers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BlockStateConfigList<VALUE>
extends ResourceConfigList<BlockStateConfigList<VALUE>, IBlockState, VALUE> {
    protected static final Pattern BLOCK_PROP_REGEX = Pattern.compile("^(.*):([^=\\s]*)\\[((?:[\\w.]+:[\\w.]+,?)+)\\](?:=(.*))?");

    public BlockStateConfigList(String name, Consumer<BlockStateConfigList<VALUE>> reloadCallback) {
        super(name, "https://github.com/BuiltBrokenModding/ICBM-Classic/wiki/config-block-states", reloadCallback);
        this.addMatcher(BLOCK_PROP_REGEX, this::handleBlockProps);
        this.addMatcher(META_KEY_REGEX, this::handleMeta);
        this.addMatcher(KEY_VALUE_REGEX, this::handleSimple);
    }

    @Override
    protected ResourceLocation getContentKey(IBlockState iBlockState) {
        return iBlockState.func_177230_c().getRegistryName();
    }

    @Override
    protected Function<IBlockState, VALUE> getMetaValue(ResourceLocation key, int metadata, @Nullable VALUE value) {
        return blockState -> {
            if (this.getContentKey((IBlockState)blockState) == key && blockState.func_177230_c().func_176201_c(blockState) == metadata) {
                return value;
            }
            return null;
        };
    }

    protected Function<IBlockState, VALUE> getPropValue(ResourceLocation key, Map<IProperty, Function<Comparable, Boolean>> propMatchers, @Nullable VALUE value) {
        return blockState -> {
            if (this.getContentKey((IBlockState)blockState) == key) {
                ImmutableMap stateProps = blockState.func_177228_b();
                for (IProperty propKey : propMatchers.keySet()) {
                    if (!stateProps.containsKey((Object)propKey)) {
                        return null;
                    }
                    Function check = (Function)propMatchers.get(propKey);
                    if (check == null || ((Boolean)check.apply(stateProps.get((Object)propKey))).booleanValue()) continue;
                    return null;
                }
                return value;
            }
            return null;
        };
    }

    protected ResourceConfigEntry<IBlockState, VALUE> handleBlockProps(Matcher domainMatcher, String source, String entry, int index) {
        String[] props;
        String resource;
        String domain = domainMatcher.group(1);
        ResourceLocation key = new ResourceLocation(domain, resource = domainMatcher.group(2));
        if (!this.isDomainValid(key.func_110624_b())) {
            this.error(source, entry, "No matching mod domain found for '" + key + "'");
            return null;
        }
        if (!this.isValidKey(key)) {
            this.error(source, entry, "No matching content found for '" + key + "'");
            return null;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        Map<IProperty, Function<Comparable, Boolean>> propMatchers = this.collectBlockProps(source, entry, block, props = domainMatcher.group(3).split(","));
        if (propMatchers == null) {
            return null;
        }
        String valueStr = domainMatcher.group(4);
        Object value = this.parseValue(source, entry, valueStr);
        Function matcher = this.getPropValue(key, propMatchers, value);
        return new ResourceConfigEntry("resource_block_state", index, matcher);
    }

    @Override
    protected boolean isValidKey(ResourceLocation targetKey) {
        return ForgeRegistryHelpers.contains(ForgeRegistries.BLOCKS, targetKey);
    }

    protected Map<IProperty, Function<Comparable, Boolean>> collectBlockProps(String source, String entry, Block block, String[] props) {
        HashMap<IProperty, Function<Comparable, Boolean>> matchers = new HashMap<IProperty, Function<Comparable, Boolean>>();
        for (String propEntry : props) {
            Matcher propMatcher = KEY_VALUE_REGEX.matcher(propEntry);
            if (!propMatcher.matches()) {
                return null;
            }
            String propKey = propMatcher.group(1);
            String propValue = propMatcher.group(2);
            IProperty property = block.func_176194_O().func_185920_a(propKey);
            if (property == null) {
                this.error(source, entry, String.format("Failed to find property '%s' for block '%s' matching entry `%s`", propKey, block.getRegistryName(), propEntry));
                return null;
            }
            if (propValue.equals("~")) {
                matchers.put(property, o -> true);
                continue;
            }
            if (propValue.startsWith("~") || propValue.endsWith("~")) {
                String stringMatch = propValue.substring(1).trim();
                List valuesToMatch = property.func_177700_c().stream().filter(o -> {
                    if (propValue.endsWith("~")) {
                        return property.func_177702_a((Comparable)o).endsWith(stringMatch);
                    }
                    return property.func_177702_a((Comparable)o).startsWith(stringMatch);
                }).collect(Collectors.toList());
                if (valuesToMatch.isEmpty()) {
                    this.error(source, entry, String.format("Failed to find values matching '%s' for property '%s' and block '%s' matching entry '%s'", propValue, propKey, block.getRegistryName(), propEntry));
                    return null;
                }
                matchers.put(property, valuesToMatch::contains);
                continue;
            }
            Optional<Object> value = property.func_177700_c().stream().filter(o -> property.func_177702_a((Comparable)o).equalsIgnoreCase(propValue)).findFirst();
            if (!value.isPresent()) {
                this.error(source, entry, String.format("Failed to find values matching '%s' for property '%s' and block '%s' matching entry '%s'", propValue, propKey, block.getRegistryName(), propEntry));
                return null;
            }
            matchers.put(property, o -> Objects.equals(value.get(), o));
        }
        return matchers;
    }

    protected IBlockState parseBlockState(String source, String entry, String valueToParse) {
        Matcher matcher;
        Block block;
        Matcher metaMatcher = META_KEY_REGEX.matcher(valueToParse);
        if (metaMatcher.matches()) {
            String resource;
            String domain = metaMatcher.group(1);
            ResourceLocation key = new ResourceLocation(domain, resource = metaMatcher.group(2));
            if (!this.isDomainValid(key.func_110624_b())) {
                this.error(source, entry, "No matching mod domain found for '" + key + "'");
                return null;
            }
            if (!this.isValidKey(key)) {
                this.error(source, entry, "No matching content found for '" + key + "'");
                return null;
            }
            int meta = Integer.parseInt(metaMatcher.group(3));
            block = (Block)ForgeRegistries.BLOCKS.getValue(key);
            if (block != null) {
                return block.func_176203_a(meta);
            }
        }
        if ((matcher = KEY_VALUE_REGEX.matcher(valueToParse)).matches()) {
            String resource;
            String domain = matcher.group(1);
            ResourceLocation key = new ResourceLocation(domain, resource = matcher.group(2));
            if (!this.isDomainValid(key.func_110624_b())) {
                this.error(source, entry, "No matching mod domain found for '" + key + "'");
                return null;
            }
            if (!this.isValidKey(key)) {
                this.error(source, entry, "No matching content found for '" + key + "'");
                return null;
            }
            block = (Block)ForgeRegistries.BLOCKS.getValue(key);
            if (block != null) {
                return block.func_176223_P();
            }
        }
        return null;
    }

    public static class FloatOut
    extends BlockStateConfigList<Float> {
        public FloatOut(String name, Consumer<BlockStateConfigList<Float>> reloadCallback) {
            super(name, reloadCallback);
        }

        @Override
        protected Float parseValue(String source, String entry, String value) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                this.error(source, entry, "Value is not a Float");
                return null;
            }
        }
    }

    public static class BlockChanceOut
    extends BlockStateConfigList<Pair<IBlockState, Float>> {
        public BlockChanceOut(String name, Consumer<BlockStateConfigList<Pair<IBlockState, Float>>> reloadCallback) {
            super(name, reloadCallback);
        }

        @Override
        protected Pair<IBlockState, Float> parseValue(String source, String entry, String value) {
            if (value.contains(",")) {
                String[] split = value.split(",");
                return Pair.of((Object)super.parseBlockState(source, entry, split[0]), (Object)Float.valueOf(Math.min(1.0f, Math.max(0.0f, Float.parseFloat(split[1])))));
            }
            return Pair.of((Object)super.parseBlockState(source, entry, value), null);
        }
    }

    public static class BlockOut
    extends BlockStateConfigList<IBlockState> {
        public BlockOut(String name, Consumer<BlockStateConfigList<IBlockState>> reloadCallback) {
            super(name, reloadCallback);
        }

        @Override
        protected IBlockState parseValue(String source, String entry, @Nullable String value) {
            return super.parseBlockState(source, entry, value);
        }
    }
}

