/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config.missile;

import net.minecraftforge.common.config.Config;

public class ConfigClusterMissile {
    @Config.Name(value="health")
    @Config.Comment(value={"Amount of damage a missile can take from any source before death"})
    @Config.RangeDouble(min=1.0E-4, max=10.0)
    public float MAX_HEALTH = 100.0f;
    @Config.Name(value="item_ban_allow")
    @Config.Comment(value={"Items allowed for insertion into cluster missile as a projectile payload"})
    public BanList BAN_ALLOW = new BanList();
    @Config.Name(value="item_sizes")
    @Config.Comment(value={"Items volume size for insertion into cluster missiles"})
    public ItemSizes ITEM_SIZES = new ItemSizes();

    public static class BanList {
        @Config.Name(value="ban")
        @Config.Comment(value={"Set to true to ban all blocks contained. False to use as allow list"})
        public boolean BAN = true;
        @Config.Name(value="list")
        @Config.Comment(value={"Item/ItemStack names 'domain:resource=ignore' set 'ignore' to true to skip the entry during loading; ex: 'minecraft:stone' will be used while 'minecraft:fire=true' will be ignored"})
        public String[] ITEMS = new String[]{"minecraft:fire=true"};
    }

    public static class ItemSizes {
        @Config.Name(value="max_size")
        @Config.Comment(value={"Volume of the cluster missile, most items default to size of 1. Keep it small to avoid lag"})
        @Config.RangeInt(min=1)
        public int MAX_SIZE = 200;
        @Config.Name(value="default_size")
        @Config.Comment(value={"Default volume to use for items if no configuration exists"})
        @Config.RangeInt(min=1)
        public int DEFAULT_SIZE = 1;
        @Config.Name(value="list")
        @Config.Comment(value={"Item/ItemStack sizes 'domain:resource=whole_number', ex: 'minecraft:stone=4'"})
        public String[] ITEMS = new String[]{"minecraft:fire=999"};
    }
}

