/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client.render.entity;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.client.render.entity.item.RenderItemImp;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.entity.itemstack.EntityHeldItemMissile;
import icbm.classic.content.missile.entity.itemstack.item.CapabilityHeldItemMissile;
import icbm.classic.content.reg.ItemReg;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderMissile
extends RenderItemImp<EntityMissile> {
    public static RenderMissile INSTANCE;

    public RenderMissile(RenderManager renderManager) {
        super(renderManager);
    }

    @Override
    protected ItemStack getRenderItem(EntityMissile entity, int index) {
        if (index == 1 && entity instanceof EntityHeldItemMissile) {
            return ((EntityHeldItemMissile)entity).getItemStackHandler().getStackInSlot(0);
        }
        return entity.toStack();
    }

    @Override
    protected void translate(@Nullable EntityMissile entity, ItemStack itemstack, IBakedModel iBakedModel, double x, double y, double z, float partialTicks, int index) {
        if (entity != null) {
            GlStateManager.func_179137_b((double)x, (double)(y + 0.2), (double)z);
        } else {
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        }
    }

    @Override
    protected float getYaw(@Nonnull EntityMissile entityMissile, float providedYaw, float partialTicks) {
        return providedYaw - 180.0f;
    }

    @Override
    protected float getPitch(@Nonnull EntityMissile entityMissile, float providedPitch, float partialTicks) {
        return providedPitch - 90.0f;
    }

    @Override
    protected void rotate(@Nullable EntityMissile entityMissile, ItemStack itemstack, float entityYaw, float entityPitch, float partialTicks, int index) {
        if (index == 0) {
            GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)entityPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (index == 1) {
            GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(entityPitch + 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entityMissile != null) {
            if (index == 0) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.8, (double)0.0);
            } else if (index == 1) {
                GlStateManager.func_179137_b((double)0.0, (double)0.27, (double)-0.12);
            }
        } else if (index == 1) {
            GlStateManager.func_179137_b((double)0.0, (double)1.1, (double)-0.27);
        }
    }

    @Override
    protected ItemCameraTransforms.TransformType getTransformType(int index) {
        if (index == 1) {
            return ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
        }
        return ItemCameraTransforms.TransformType.NONE;
    }

    @Override
    protected void scale(@Nullable EntityMissile e, ItemStack itemstack, float partialTicks, int index) {
        if (index == 1 && !itemstack.func_77973_b().func_77662_d()) {
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        }
    }

    @Override
    public void renderItem(ItemStack missileStack, World world, double x, double y, double z, float entityYaw, float entityPitch, float partialTicks) {
        ICapabilityMissileStack cap;
        super.renderItem(missileStack, world, x, y, z, entityYaw, entityPitch, partialTicks);
        if (missileStack.func_77973_b() == ItemReg.heldItemMissile && (cap = (ICapabilityMissileStack)missileStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) instanceof CapabilityHeldItemMissile) {
            this.renderItem(null, ((CapabilityHeldItemMissile)cap).getHeldItem(), world, x, y, z, entityYaw, entityPitch, partialTicks, 1);
        }
    }

    @Override
    protected void doRenderItem(@Nonnull EntityMissile entity, World world, double x, double y, double z, float yaw, float pitch, float partialTicks) {
        super.doRenderItem(entity, world, x, y, z, yaw, pitch, partialTicks);
        if (entity instanceof EntityHeldItemMissile) {
            this.renderItem(entity, this.getRenderItem(entity, 1), entity.field_70170_p, x, y, z, yaw, pitch, partialTicks, 1);
        }
    }

    public void doRender(EntityMissile entityMissile, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a(entityMissile, x, y, z, entityYaw, partialTicks);
        if (this.field_76990_c.func_178634_b()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(x, y, z).func_181669_b(0, 255, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(x + entityMissile.field_70159_w * 2.0, y + entityMissile.field_70181_x * 2.0, z + entityMissile.field_70179_y * 2.0).func_181669_b(0, 255, 0, 2555).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        }
    }
}

