/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.api.reg.obj;

import icbm.classic.ICBMClassic;
import icbm.classic.api.reg.obj.IBuildableObject;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public interface IBuilderRegistry<Part extends IBuildableObject> {
    public void register(@Nonnull ResourceLocation var1, @Nonnull Supplier<Part> var2);

    @Nullable
    public Part getOrBuild(@Nonnull ResourceLocation var1);

    @Nonnull
    public String getUniqueName();

    default public NBTTagList save(@Nonnull Collection<Part> parts) {
        NBTTagList list = new NBTTagList();
        for (IBuildableObject part : parts) {
            NBTTagCompound save = this.save(part);
            if (save == null) continue;
            list.func_74742_a((NBTBase)save);
        }
        return list;
    }

    default public NBTTagCompound save(@Nonnull Part part) {
        NBTBase additionalData;
        if (part == null) {
            ICBMClassic.logger().warn("Failed to save part due to null value", (Throwable)new RuntimeException());
            return null;
        }
        if (part.getRegistryKey() == null) {
            ICBMClassic.logger().warn("Failed to save part due to missing registry name: " + part, (Throwable)new RuntimeException());
            return null;
        }
        NBTTagCompound save = new NBTTagCompound();
        save.func_74778_a("id", part.getRegistryKey().toString());
        if (part instanceof INBTSerializable && (additionalData = ((INBTSerializable)part).serializeNBT()) != null && (!additionalData.func_82582_d() || additionalData instanceof NBTPrimitive)) {
            save.func_74782_a("data", additionalData);
        }
        return save;
    }

    default public <C extends Collection<Part>> C load(@Nonnull NBTTagList save, @Nonnull C list) {
        for (int i = 0; i < save.func_74745_c(); ++i) {
            Part part = this.load((NBTTagCompound)save.func_179238_g(i));
            if (part == null) continue;
            list.add(part);
        }
        return list;
    }

    default public Part load(@Nullable NBTTagCompound save) {
        if (save != null && !save.func_82582_d() && save.func_74764_b("id")) {
            ResourceLocation id = new ResourceLocation(save.func_74779_i("id"));
            Part part = this.getOrBuild(id);
            if (part instanceof INBTSerializable && save.func_74764_b("data")) {
                NBTBase additionalData = save.func_74781_a("data");
                ((INBTSerializable)part).deserializeNBT(additionalData);
            }
            return part;
        }
        return null;
    }

    public boolean isLocked();
}

