/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.api.actions.data;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.nbt.NBTBase;

public class ActionField<VALUE, TAG extends NBTBase> {
    private static Map<String, ActionField> fields = new HashMap<String, ActionField>();
    private final String key;
    private final Type type;
    private final Function<VALUE, TAG> save;
    private final Function<TAG, VALUE> load;

    public static <VALUE, TAG extends NBTBase> ActionField<VALUE, TAG> getOrCreate(String key, Type type, Function<VALUE, TAG> save, Function<TAG, VALUE> load) {
        ActionField<VALUE, TAG> field = ActionField.find(key, null);
        if (field != null && field.type != type) {
            throw new IllegalArgumentException("Key " + key + " was requested with different type " + type + " when it already uses " + field.type);
        }
        return fields.computeIfAbsent(key, k -> new ActionField(key, type, save, load));
    }

    public static <VALUE, TAG extends NBTBase> ActionField<VALUE, TAG> find(String key, Type type) {
        ActionField field = fields.get(key);
        if (field != null && (type == null || field.type == type)) {
            return field;
        }
        return null;
    }

    public VALUE cast(Object v) {
        return (VALUE)v;
    }

    public TAG save(VALUE v) {
        return (TAG)(this.save != null ? (NBTBase)this.save.apply(v) : null);
    }

    public VALUE load(TAG v) {
        return this.load != null ? (VALUE)this.load.apply(v) : null;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Function<VALUE, TAG> getSave() {
        return this.save;
    }

    @Generated
    public Function<TAG, VALUE> getLoad() {
        return this.load;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionField)) {
            return false;
        }
        ActionField other = (ActionField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Function<VALUE, TAG> this$save = this.getSave();
        Function<VALUE, TAG> other$save = other.getSave();
        if (this$save == null ? other$save != null : !this$save.equals(other$save)) {
            return false;
        }
        Function<TAG, VALUE> this$load = this.getLoad();
        Function<TAG, VALUE> other$load = other.getLoad();
        return !(this$load == null ? other$load != null : !this$load.equals(other$load));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActionField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Function<VALUE, TAG> $save = this.getSave();
        result = result * 59 + ($save == null ? 43 : $save.hashCode());
        Function<TAG, VALUE> $load = this.getLoad();
        result = result * 59 + ($load == null ? 43 : $load.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ActionField(key=" + this.getKey() + ", type=" + this.getType() + ", save=" + this.getSave() + ", load=" + this.getLoad() + ")";
    }

    @Generated
    private ActionField(String key, Type type, Function<VALUE, TAG> save, Function<TAG, VALUE> load) {
        this.key = key;
        this.type = type;
        this.save = save;
        this.load = load;
    }
}

