/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic;

import icbm.classic.CommonProxy;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.reg.IExplosiveCustomization;
import icbm.classic.api.reg.events.ExplosiveContentRegistryEvent;
import icbm.classic.api.reg.events.ExplosiveCustomizationRegistryEvent;
import icbm.classic.api.reg.events.ExplosiveRegistryEvent;
import icbm.classic.api.reg.events.MissileFlightLogicRegistryEvent;
import icbm.classic.api.reg.events.MissileTargetRegistryEvent;
import icbm.classic.api.reg.events.ProjectileDataRegistryEvent;
import icbm.classic.client.ICBMCreativeTab;
import icbm.classic.command.ICBMCommands;
import icbm.classic.command.system.CommandEntryPoint;
import icbm.classic.config.ConfigItems;
import icbm.classic.config.ConfigThread;
import icbm.classic.content.blast.caps.CapabilityBlast;
import icbm.classic.content.blast.caps.CapabilityBlastVelocity;
import icbm.classic.content.blast.ender.EnderBlastCustomization;
import icbm.classic.content.cargo.CargoHolderHandler;
import icbm.classic.content.cargo.RecipeCargoData;
import icbm.classic.content.cargo.RecipeCargoDataDecraft;
import icbm.classic.content.cargo.balloon.BalloonProjectileData;
import icbm.classic.content.cargo.parachute.ParachuteProjectileData;
import icbm.classic.content.cluster.bomblet.BombletProjectileData;
import icbm.classic.content.cluster.missile.ClusterMissileHandler;
import icbm.classic.content.cluster.missile.RecipeCluster;
import icbm.classic.content.entity.flyingblock.FlyingBlock;
import icbm.classic.content.gas.ProtectiveArmorHandler;
import icbm.classic.content.items.behavior.BombCartDispenseBehavior;
import icbm.classic.content.items.behavior.GrenadeDispenseBehavior;
import icbm.classic.content.missile.entity.CapabilityMissile;
import icbm.classic.content.missile.entity.anti.SAMTargetData;
import icbm.classic.content.missile.entity.itemstack.item.HeldItemMissileHandler;
import icbm.classic.content.missile.entity.itemstack.item.RecipeHeldItemMissile;
import icbm.classic.content.missile.entity.itemstack.item.RecipeHeldItemMissileDecraft;
import icbm.classic.content.missile.logic.flight.ArcFlightLogic;
import icbm.classic.content.missile.logic.flight.BallisticFlightLogicOld;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import icbm.classic.content.missile.logic.flight.DirectFlightLogic;
import icbm.classic.content.missile.logic.flight.FollowTargetLogic;
import icbm.classic.content.missile.logic.flight.WarmupFlightLogic;
import icbm.classic.content.missile.logic.flight.move.MoveByFacingLogic;
import icbm.classic.content.missile.logic.flight.move.MoveByVec3Logic;
import icbm.classic.content.missile.logic.flight.move.MoveForTicksLogic;
import icbm.classic.content.missile.logic.targeting.BallisticTargetingData;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.content.potion.ContagiousPoison;
import icbm.classic.content.radioactive.RadioactiveHandler;
import icbm.classic.content.reg.ExplosiveInit;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.datafix.EntityBombCartDataFixer;
import icbm.classic.datafix.EntityExplosiveDataFixer;
import icbm.classic.datafix.EntityGrenadeDataFixer;
import icbm.classic.datafix.EntityMissileDataFixer;
import icbm.classic.datafix.ItemStackDataFixer;
import icbm.classic.datafix.TileExplosivesDataFixer;
import icbm.classic.datafix.TileRadarStationDataFixer;
import icbm.classic.lib.actions.ActionSystem;
import icbm.classic.lib.buildable.BuildableObjectRegistry;
import icbm.classic.lib.capability.chicken.CapSpaceChicken;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.capability.ex.CapabilityExplosive;
import icbm.classic.lib.capability.gps.CapabilityGPSData;
import icbm.classic.lib.capability.launcher.CapabilityMissileHolder;
import icbm.classic.lib.capability.launcher.CapabilityMissileLauncher;
import icbm.classic.lib.capability.missile.CapabilityMissileStack;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.energy.system.EnergySystemFE;
import icbm.classic.lib.explosive.reg.ExBlockContentReg;
import icbm.classic.lib.explosive.reg.ExGrenadeContentReg;
import icbm.classic.lib.explosive.reg.ExMinecartContentReg;
import icbm.classic.lib.explosive.reg.ExMissileContentReg;
import icbm.classic.lib.explosive.reg.ExplosiveRegistry;
import icbm.classic.lib.network.netty.PacketManager;
import icbm.classic.lib.projectile.CapabilityProjectileStack;
import icbm.classic.lib.projectile.ProjectileDataRegistry;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.radio.CapabilityRadio;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.thread.WorkerThreadManager;
import icbm.classic.lib.tracker.EventTracker;
import icbm.classic.lib.world.ProjectileBlockInteraction;
import icbm.classic.prefab.item.LootEntryItemStack;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="icbmclassic", name="ICBM-Classic")
@Mod.EventBusSubscriber
public class ICBMClassic {
    public static final int DATA_FIXER_VERSION = 5;
    public static final boolean runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    @Mod.Instance(value="icbmclassic")
    public static ICBMClassic INSTANCE;
    @Mod.Metadata(value="icbmclassic")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="icbm.classic.client.ClientProxy", serverSide="icbm.classic.CommonProxy")
    public static CommonProxy proxy;
    public static final int MAP_HEIGHT = 255;
    @Deprecated
    private static final Logger logger;
    public static final PacketManager packetHandler;
    public static final ContagiousPoison chemicalPotion;
    public static final ContagiousPoison contagiousPotion;
    public static final ICBMCreativeTab CREATIVE_TAB;
    public static ModFixs modFixs;
    public static final EventTracker MAIN_TRACKER;

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (ConfigItems.ENABLE_CRAFTING_ITEMS) {
            if (ConfigItems.ENABLE_INGOTS_ITEMS) {
                GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ItemReg.itemIngotClump, 1, 0), (ItemStack)new ItemStack((Item)ItemReg.itemIngot, 1, 0), (float)0.1f);
            }
            if (ConfigItems.ENABLE_PLATES_ITEMS) {
                GameRegistry.addSmelting((ItemStack)ItemReg.itemPlate.getStack("iron", 1), (ItemStack)new ItemStack(Items.field_151042_j), (float)0.0f);
            }
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemReg.itemSaltpeterBall, 1, 0), (ItemStack)new ItemStack(ItemReg.itemSaltpeterDust, 1, 0), (float)0.1f);
        event.getRegistry().register(new RecipeCargoData(new ItemStack((Item)ItemReg.itemBalloon), BalloonProjectileData::new).setRegistryName(new ResourceLocation("icbmclassic", "balloon_cargo")));
        event.getRegistry().register(new RecipeCargoDataDecraft(ItemReg.itemBalloon).setRegistryName(new ResourceLocation("icbmclassic", "balloon_cargo_decraft")));
        event.getRegistry().register(new RecipeCargoData(new ItemStack((Item)ItemReg.itemParachute), ParachuteProjectileData::new).setRegistryName(new ResourceLocation("icbmclassic", "parachute_cargo")));
        event.getRegistry().register(new RecipeCargoDataDecraft(ItemReg.itemParachute).setRegistryName(new ResourceLocation("icbmclassic", "parachute_cargo_decraft")));
        event.getRegistry().register(new RecipeCluster(new ItemStack(ItemReg.itemClusterMissile)).setRegistryName(new ResourceLocation("icbmclassic", "cluster_missile")));
        event.getRegistry().register(new RecipeHeldItemMissile(new ItemStack((Item)ItemReg.heldItemMissile)).setRegistryName(new ResourceLocation("icbmclassic", "held_item_missile")));
        event.getRegistry().register(new RecipeHeldItemMissileDecraft(ItemReg.heldItemMissile).setRegistryName(new ResourceLocation("icbmclassic", "held_item_missile_decraft")));
    }

    @SubscribeEvent
    public static void registerLoot(LootTableLoadEvent event) {
        LootPool lootPool;
        String VANILLA_LOOT_POOL_ID = "main";
        if (event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186422_d)) {
            LootPool lootPool2;
            if (ConfigItems.ENABLE_LOOT_DROPS && (lootPool2 = event.getTable().getPool("main")) != null && ConfigItems.ENABLE_CRAFTING_ITEMS) {
                if (ConfigItems.ENABLE_INGOTS_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:ingot.copper", ItemReg.itemIngot.getStack("copper", 10), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:ingot.steel", ItemReg.itemIngot.getStack("steel", 10), 20, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_PLATES_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:plate.steel", ItemReg.itemPlate.getStack("steel", 5), 30, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_WIRES_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:wire.copper", ItemReg.itemWire.getStack("copper", 20), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:wire.gold", ItemReg.itemWire.getStack("gold", 15), 30, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_CIRCUIT_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.basic", ItemReg.itemCircuit.getStack("basic", 15), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.advanced", ItemReg.itemCircuit.getStack("advanced", 11), 30, 3, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.elite", ItemReg.itemCircuit.getStack("elite", 8), 30, 3, new LootCondition[0]));
                }
            }
        } else if ((event.getName().equals((Object)LootTableList.field_186434_p) || event.getName().equals((Object)LootTableList.field_186433_o)) && ConfigItems.ENABLE_SULFUR_LOOT_DROPS && (lootPool = event.getTable().getPool("main")) != null) {
            lootPool.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:sulfur", new ItemStack(ItemReg.itemSulfurDust, 10, 0), 2, 0, new LootCondition[0]));
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        EnergySystem.register(new EnergySystemFE());
        this.registerCapabilities();
        modFixs = FMLCommonHandler.instance().getDataFixer().init("icbmclassic", 5);
        modFixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new EntityExplosiveDataFixer());
        modFixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new EntityBombCartDataFixer());
        modFixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new EntityGrenadeDataFixer());
        modFixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)EntityMissileDataFixer.INSTANCE);
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileExplosivesDataFixer());
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileRadarStationDataFixer());
        modFixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new ItemStackDataFixer());
        MinecraftForge.EVENT_BUS.register((Object)RadarRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RadioRegistry.INSTANCE);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.handleMissileTargetRegistry();
        this.handleMissileFlightRegistry();
        ActionSystem.setup();
        this.handleExplosiveCustomizationRegistry();
        this.handleExRegistry(event.getModConfigurationDirectory());
        this.handleProjectileDataRegistry();
    }

    void registerCapabilities() {
        CapabilityEMP.register();
        CapabilityMissile.register();
        CapabilityExplosive.register();
        CapabilityBlast.register();
        CapabilityBlastVelocity.register();
        CapabilityMissileHolder.register();
        CapabilityMissileStack.register();
        CapabilityProjectileStack.register();
        CapabilityMissileLauncher.register();
        CapabilityRadio.register();
        CapSpaceChicken.register();
        CapabilityGPSData.register();
    }

    void handleMissileTargetRegistry() {
        ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY = new BuildableObjectRegistry<IMissileTarget>("TARGET_DATA");
        ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY.register(BasicTargetData.REG_NAME, BasicTargetData::new);
        ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY.register(BallisticTargetingData.REG_NAME, BallisticTargetingData::new);
        ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY.register(SAMTargetData.REG_NAME, () -> null);
        MinecraftForge.EVENT_BUS.post((Event)new MissileTargetRegistryEvent(ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY));
        ((BuildableObjectRegistry)ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY).lock();
    }

    void handleMissileFlightRegistry() {
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY = new BuildableObjectRegistry<IMissileFlightLogic>("FLIGHT_LOGIC");
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(DirectFlightLogic.REG_NAME, DirectFlightLogic::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(BallisticFlightLogicOld.REG_NAME, BallisticFlightLogicOld::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(ArcFlightLogic.REG_NAME, ArcFlightLogic::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(WarmupFlightLogic.REG_NAME, WarmupFlightLogic::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(MoveByFacingLogic.REG_NAME, MoveByFacingLogic::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(MoveByVec3Logic.REG_NAME, MoveByVec3Logic::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(MoveForTicksLogic.REG_NAME, MoveForTicksLogic::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(DeadFlightLogic.REG_NAME, DeadFlightLogic::new);
        ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY.register(FollowTargetLogic.REG_NAME, FollowTargetLogic::new);
        MinecraftForge.EVENT_BUS.post((Event)new MissileFlightLogicRegistryEvent(ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY));
        ((BuildableObjectRegistry)ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY).lock();
    }

    void handleExplosiveCustomizationRegistry() {
        ICBMClassicAPI.EXPLOSIVE_CUSTOMIZATION_REGISTRY = new BuildableObjectRegistry<IExplosiveCustomization>("EXPLOSIVE_CUSTOMIZATION");
        ICBMClassicAPI.EXPLOSIVE_CUSTOMIZATION_REGISTRY.register(EnderBlastCustomization.NAME, EnderBlastCustomization::new);
        MinecraftForge.EVENT_BUS.post((Event)new ExplosiveCustomizationRegistryEvent(ICBMClassicAPI.EXPLOSIVE_CUSTOMIZATION_REGISTRY));
        ((BuildableObjectRegistry)ICBMClassicAPI.EXPLOSIVE_CUSTOMIZATION_REGISTRY).lock();
    }

    void handleProjectileDataRegistry() {
        ICBMClassicAPI.PROJECTILE_DATA_REGISTRY = new ProjectileDataRegistry();
        ICBMClassicAPI.PROJECTILE_DATA_REGISTRY.register(BombletProjectileData.NAME, BombletProjectileData::new);
        ICBMClassicAPI.PROJECTILE_DATA_REGISTRY.register(ParachuteProjectileData.NAME, ParachuteProjectileData::new);
        ICBMClassicAPI.PROJECTILE_DATA_REGISTRY.register(BalloonProjectileData.NAME, BalloonProjectileData::new);
    }

    void handleExRegistry(File configMainFolder) {
        ExplosiveRegistry explosiveRegistry = new ExplosiveRegistry();
        ICBMClassicAPI.EXPLOSIVE_REGISTRY = explosiveRegistry;
        ICBMClassicAPI.EX_BLOCK_REGISTRY = new ExBlockContentReg();
        ICBMClassicAPI.EX_GRENADE_REGISTRY = new ExGrenadeContentReg();
        ICBMClassicAPI.EX_MINECART_REGISTRY = new ExMinecartContentReg();
        ICBMClassicAPI.EX_MISSILE_REGISTRY = new ExMissileContentReg();
        if (configMainFolder != null) {
            explosiveRegistry.loadReg(new File(configMainFolder, "icbmclassic/explosive_reg.json"));
        }
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_BLOCK_REGISTRY);
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_GRENADE_REGISTRY);
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_MISSILE_REGISTRY);
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_MINECART_REGISTRY);
        MinecraftForge.EVENT_BUS.post((Event)new ExplosiveContentRegistryEvent(explosiveRegistry));
        explosiveRegistry.lockNewContentTypes();
        ExplosiveInit.init();
        MinecraftForge.EVENT_BUS.post((Event)new ExplosiveRegistryEvent(explosiveRegistry));
        explosiveRegistry.lockNewExplosives();
        explosiveRegistry.completeLock();
        if (configMainFolder != null) {
            explosiveRegistry.saveReg();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        packetHandler.init();
        CREATIVE_TAB.init();
        ProjectileBlockInteraction.register();
        ClusterMissileHandler.setup();
        CargoHolderHandler.setup();
        HeldItemMissileHandler.setup();
        RadioactiveHandler.setup();
        ProtectiveArmorHandler.setup();
        ((ProjectileDataRegistry)ICBMClassicAPI.PROJECTILE_DATA_REGISTRY).registerVanillaDefaults();
        MinecraftForge.EVENT_BUS.post((Event)new ProjectileDataRegistryEvent(ICBMClassicAPI.PROJECTILE_DATA_REGISTRY));
        ((ProjectileDataRegistry)ICBMClassicAPI.PROJECTILE_DATA_REGISTRY).lock();
        if (ItemReg.itemGrenade != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)ItemReg.itemGrenade, (Object)new GrenadeDispenseBehavior());
        }
        if (ItemReg.itemBombCart != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)ItemReg.itemBombCart, (Object)new BombCartDispenseBehavior());
        }
        FlyingBlock.loadFromConfig();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        ICBMCommands.init();
        serverCommandManager.func_71560_a((ICommand)new CommandEntryPoint("icbm", ICBMCommands.ICBM_COMMAND));
        WorkerThreadManager.INSTANCE = new WorkerThreadManager(ConfigThread.THREAD_COUNT);
        WorkerThreadManager.INSTANCE.startThreads();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        WorkerThreadManager.INSTANCE.killThreads();
    }

    public static Logger logger() {
        return logger;
    }

    public static boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.") && !element.getClassName().startsWith("com.builtbroken.mc.testing.junit.VoltzTestRunner")) continue;
            return true;
        }
        return false;
    }

    static {
        logger = LogManager.getLogger((String)"icbmclassic");
        packetHandler = new PacketManager("icbmclassic");
        chemicalPotion = new ContagiousPoison("Chemical", 0, false);
        contagiousPotion = new ContagiousPoison("Contagious", 1, true);
        CREATIVE_TAB = new ICBMCreativeTab("icbmclassic");
        MAIN_TRACKER = new EventTracker();
    }
}

