/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.io;

import com.feed_the_beast.ftblib.lib.io.FileDataReader;
import com.feed_the_beast.ftblib.lib.io.HttpDataReader;
import com.feed_the_beast.ftblib.lib.io.RequestMethod;
import com.feed_the_beast.ftblib.lib.io.ResourceDataReader;
import com.feed_the_beast.ftblib.lib.io.StreamDataReader;
import com.feed_the_beast.ftblib.lib.io.StringDataReader;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DataReader {
    public static final String TEXT = "text/plain; charset=utf-8";
    public static final String JSON = "application/json; charset=utf-8";
    public static final String HTML = "text/html; charset=utf-8";
    public static final String XML = "text/xml; charset=utf-8";
    public static final String PNG = "image/png";

    public static HttpDataReader get(URL url, RequestMethod requestMethod, String contentType, @Nullable HttpDataReader.HttpDataOutput data, Proxy proxy) {
        return new HttpDataReader(url, requestMethod, contentType, data, proxy);
    }

    public static HttpDataReader get(URL url, String contentType, Proxy proxy) {
        return DataReader.get(url, RequestMethod.GET, contentType, null, proxy);
    }

    public static FileDataReader get(File file) {
        return new FileDataReader(file);
    }

    public static StringDataReader get(@Nullable String string) {
        return new StringDataReader(string);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceDataReader get(IResource resource) {
        return new ResourceDataReader(resource);
    }

    public static StreamDataReader get(InputStream stream) {
        return new StreamDataReader(stream);
    }

    public static DataReader get(URI uri, Proxy proxy) {
        switch (uri.getScheme()) {
            case "http": 
            case "https": {
                try {
                    return DataReader.get(uri.toURL(), "", proxy);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            case "file": {
                return DataReader.get(new File(uri.getPath()));
            }
            case "string": {
                return DataReader.get(uri.getPath());
            }
            case "mcresource": {
                return DataReader.getMCResource(uri);
            }
        }
        throw new IllegalArgumentException("Unknown URI scheme: " + uri.getScheme() + "!");
    }

    private static DataReader getMCResource(URI uri) {
        try {
            return DataReader.get(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(uri.getPath())));
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Failed to load minecraft resource: " + uri.getPath() + "!");
        }
    }

    public boolean canRead() {
        return true;
    }

    public String string() throws Exception {
        return this.string(64);
    }

    public String safeString() {
        if (!this.canRead()) {
            return "";
        }
        try {
            return this.string();
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected static String readStringFromStream(InputStream stream, int bufferSize) throws Exception {
        try (InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            int read;
            char[] buffer = new char[bufferSize];
            StringBuilder out = new StringBuilder();
            do {
                if ((read = ((Reader)in).read(buffer, 0, bufferSize)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
            String string = out.toString();
            return string;
        }
    }

    public abstract String string(int var1) throws Exception;

    public abstract List<String> stringList() throws Exception;

    public List<String> safeStringList() {
        if (!this.canRead()) {
            return Collections.emptyList();
        }
        try {
            return this.stringList();
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    protected static List<String> readStringListFromStream(InputStream stream) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    public abstract JsonElement json() throws Exception;

    public JsonElement safeJson() {
        if (!this.canRead()) {
            return JsonNull.INSTANCE;
        }
        try {
            return this.json();
        }
        catch (Exception ex) {
            return JsonNull.INSTANCE;
        }
    }

    public abstract BufferedImage image() throws Exception;
}

