/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.inventory.capability;

import funwayguy.bdsandm.blocks.tiles.TileEntityShipping;
import funwayguy.bdsandm.inventory.InventoryShipping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ShippingProxyWrapper
implements IItemHandler,
IFluidHandler,
IEnergyStorage,
IInventoryChangedListener {
    private final InventoryShipping shipInvo;
    private final TreeSet<ProxyEntry<IItemHandler>> invoItems = new TreeSet();
    private final TreeSet<ProxyEntry<IFluidHandlerItem>> fluidItems = new TreeSet();
    private final TreeSet<ProxyEntry<IEnergyStorage>> energyItems = new TreeSet();
    private boolean skipRefresh = false;

    public ShippingProxyWrapper(TileEntityShipping tileShip, InventoryShipping invo) {
        this.shipInvo = invo;
        this.shipInvo.func_110134_a(this);
        this.shipInvo.func_110134_a(tileShip);
    }

    private void markDirty() {
        this.skipRefresh = true;
        this.shipInvo.func_70296_d();
        this.skipRefresh = false;
    }

    private void refreshProxyEntries() {
        if (this.skipRefresh) {
            return;
        }
        this.invoItems.clear();
        this.fluidItems.clear();
        this.energyItems.clear();
        for (int i = 0; i < this.shipInvo.func_70302_i_(); ++i) {
            ItemStack stack = this.shipInvo.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler itemHandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                assert (itemHandler != null);
                this.invoItems.add(new ProxyEntry(i, itemHandler));
            }
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                assert (fluidHandlerItem != null);
                this.fluidItems.add(new ProxyEntry(i, fluidHandlerItem));
            }
            if (!stack.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            assert (energyStorage != null);
            this.energyItems.add(new ProxyEntry(i, energyStorage));
        }
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        this.refreshProxyEntries();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int pushed = 0;
        Iterator<ProxyEntry<IEnergyStorage>> eIter = this.energyItems.iterator();
        while (eIter.hasNext() && pushed < maxReceive) {
            ProxyEntry<IEnergyStorage> eStore = eIter.next();
            if (!((IEnergyStorage)((ProxyEntry)eStore).handler).canReceive()) continue;
            pushed += ((IEnergyStorage)((ProxyEntry)eStore).handler).receiveEnergy(maxReceive - pushed, simulate);
        }
        if (pushed != 0 && !simulate) {
            this.markDirty();
        }
        return pushed;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int pulled = 0;
        Iterator<ProxyEntry<IEnergyStorage>> eIter = this.energyItems.iterator();
        while (eIter.hasNext() && pulled < maxExtract) {
            ProxyEntry<IEnergyStorage> eStore = eIter.next();
            if (!((IEnergyStorage)((ProxyEntry)eStore).handler).canExtract()) continue;
            pulled += ((IEnergyStorage)((ProxyEntry)eStore).handler).extractEnergy(maxExtract - pulled, simulate);
        }
        if (pulled != 0 && !simulate) {
            this.markDirty();
        }
        return pulled;
    }

    public int getEnergyStored() {
        int total = 0;
        for (ProxyEntry<IEnergyStorage> eStore : this.energyItems) {
            total += ((IEnergyStorage)((ProxyEntry)eStore).handler).getEnergyStored();
        }
        return total;
    }

    public int getMaxEnergyStored() {
        int total = 0;
        for (ProxyEntry<IEnergyStorage> eStore : this.energyItems) {
            total += ((IEnergyStorage)((ProxyEntry)eStore).handler).getMaxEnergyStored();
        }
        return total;
    }

    public boolean canExtract() {
        for (ProxyEntry<IEnergyStorage> eStore : this.energyItems) {
            if (!((IEnergyStorage)((ProxyEntry)eStore).handler).canExtract()) continue;
            return true;
        }
        return false;
    }

    public boolean canReceive() {
        for (ProxyEntry<IEnergyStorage> eStore : this.energyItems) {
            if (!((IEnergyStorage)((ProxyEntry)eStore).handler).canReceive()) continue;
            return true;
        }
        return false;
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList tanks = new ArrayList();
        for (ProxyEntry<IFluidHandlerItem> eStore : this.fluidItems) {
            Collections.addAll(tanks, ((IFluidHandlerItem)((ProxyEntry)eStore).handler).getTankProperties());
        }
        return tanks.toArray(new IFluidTankProperties[0]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        FluidStack remaining = resource.copy();
        Iterator<ProxyEntry<IFluidHandlerItem>> eIter = this.fluidItems.iterator();
        while (eIter.hasNext() && remaining.amount > 0) {
            ProxyEntry<IFluidHandlerItem> eStore = eIter.next();
            int tmp = ((IFluidHandlerItem)((ProxyEntry)eStore).handler).fill(remaining, doFill);
            remaining.amount -= tmp;
            if (!doFill || tmp <= 0) continue;
            this.shipInvo.setSlotWithoutNotice(((ProxyEntry)eStore).slot, ((IFluidHandlerItem)((ProxyEntry)eStore).handler).getContainer());
        }
        this.markDirty();
        return resource.amount - remaining.amount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack requesting = resource.copy();
        FluidStack pulled = null;
        Iterator<ProxyEntry<IFluidHandlerItem>> eIter = this.fluidItems.iterator();
        while (eIter.hasNext() && requesting.amount > 0) {
            ProxyEntry<IFluidHandlerItem> eStore = eIter.next();
            FluidStack tmp = ((IFluidHandlerItem)((ProxyEntry)eStore).handler).drain(requesting, false);
            if (tmp == null || !tmp.isFluidEqual(requesting)) continue;
            ((IFluidHandlerItem)((ProxyEntry)eStore).handler).drain(requesting, doDrain);
            if (pulled == null) {
                pulled = tmp;
            } else {
                pulled.amount += tmp.amount;
            }
            requesting.amount -= tmp.amount;
            if (!doDrain) continue;
            this.shipInvo.setSlotWithoutNotice(((ProxyEntry)eStore).slot, ((IFluidHandlerItem)((ProxyEntry)eStore).handler).getContainer());
        }
        this.markDirty();
        return pulled;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int requesting = maxDrain;
        FluidStack pulled = null;
        Iterator<ProxyEntry<IFluidHandlerItem>> eIter = this.fluidItems.iterator();
        while (eIter.hasNext() && requesting > 0) {
            ProxyEntry<IFluidHandlerItem> eStore = eIter.next();
            FluidStack tmp = ((IFluidHandlerItem)((ProxyEntry)eStore).handler).drain(requesting, false);
            if (tmp == null || pulled != null && !tmp.isFluidEqual(pulled)) continue;
            ((IFluidHandlerItem)((ProxyEntry)eStore).handler).drain(requesting, doDrain);
            if (pulled == null) {
                pulled = tmp;
            } else {
                pulled.amount += tmp.amount;
            }
            requesting -= tmp.amount;
            if (!doDrain) continue;
            this.shipInvo.setSlotWithoutNotice(((ProxyEntry)eStore).slot, ((IFluidHandlerItem)((ProxyEntry)eStore).handler).getContainer());
        }
        this.markDirty();
        return pulled;
    }

    public int getSlots() {
        int total = 0;
        for (ProxyEntry<IItemHandler> eStore : this.invoItems) {
            total += ((IItemHandler)((ProxyEntry)eStore).handler).getSlots();
        }
        return total;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int index = 0;
        for (ProxyEntry<IItemHandler> eStore : this.invoItems) {
            if (slot >= index && slot < index + ((IItemHandler)((ProxyEntry)eStore).handler).getSlots()) {
                return ((IItemHandler)((ProxyEntry)eStore).handler).getStackInSlot(slot - index);
            }
            index += ((IItemHandler)((ProxyEntry)eStore).handler).getSlots();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int index = 0;
        for (ProxyEntry<IItemHandler> eStore : this.invoItems) {
            if (slot >= index && slot < index + ((IItemHandler)((ProxyEntry)eStore).handler).getSlots()) {
                ItemStack result = ((IItemHandler)((ProxyEntry)eStore).handler).insertItem(slot - index, stack, simulate);
                if (!simulate) {
                    this.markDirty();
                }
                return result;
            }
            index += ((IItemHandler)((ProxyEntry)eStore).handler).getSlots();
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int index = 0;
        for (ProxyEntry<IItemHandler> eStore : this.invoItems) {
            if (slot >= index && slot < index + ((IItemHandler)((ProxyEntry)eStore).handler).getSlots()) {
                ItemStack result = ((IItemHandler)((ProxyEntry)eStore).handler).extractItem(slot - index, amount, simulate);
                if (!simulate) {
                    this.markDirty();
                }
                return result;
            }
            index += ((IItemHandler)((ProxyEntry)eStore).handler).getSlots();
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        int index = 0;
        for (ProxyEntry<IItemHandler> eStore : this.invoItems) {
            if (slot >= index && slot < index + ((IItemHandler)((ProxyEntry)eStore).handler).getSlots()) {
                return ((IItemHandler)((ProxyEntry)eStore).handler).getSlotLimit(slot - index);
            }
            index += ((IItemHandler)((ProxyEntry)eStore).handler).getSlots();
        }
        return 0;
    }

    private class ProxyEntry<T>
    implements Comparable<ProxyEntry<T>> {
        private final int slot;
        private final T handler;

        private ProxyEntry(@Nonnull int slot, T handler) {
            this.slot = slot;
            this.handler = handler;
        }

        @Override
        public int compareTo(@Nonnull ProxyEntry<T> o) {
            return Integer.compare(this.slot, o.slot);
        }
    }
}

