/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.core;

import funwayguy.bdsandm.inventory.capability.BdsmCapabilies;
import funwayguy.bdsandm.inventory.capability.IBarrel;
import funwayguy.bdsandm.inventory.capability.ICrate;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.item.ItemStack;

public class BdsmWailaHandler
implements IWailaDataProvider {
    public static final BdsmWailaHandler INSTANCE = new BdsmWailaHandler();
    private static final DecimalFormat df = new DecimalFormat("0.##");
    private static final String[] suffixes = new String[]{"", "K", "M", "B", "T"};

    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() == null) {
            return accessor.getStack();
        }
        ICrate crate = (ICrate)accessor.getTileEntity().getCapability(BdsmCapabilies.CRATE_CAP, null);
        if (crate != null && !crate.getRefItem().func_190926_b()) {
            return crate.getRefItem();
        }
        return accessor.getStack();
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() == null) {
            return tooltip;
        }
        ICrate crate = (ICrate)accessor.getTileEntity().getCapability(BdsmCapabilies.CRATE_CAP, null);
        IBarrel barrel = (IBarrel)accessor.getTileEntity().getCapability(BdsmCapabilies.BARREL_CAP, null);
        if (barrel != null && barrel.getRefFluid() != null) {
            int stackCap = barrel.getStackCap() >= 0 ? barrel.getStackCap() : 32768;
            tooltip.add("Fluid: " + barrel.getRefFluid().getLocalizedName() + (barrel.isLocked() ? " [LOCKED]" : ""));
            tooltip.add("Amount: " + BdsmWailaHandler.formatValue(barrel.getCount()) + " mB / " + BdsmWailaHandler.formatValue(stackCap * 1000) + " mB");
            if (barrel.voidOverflow() || barrel.getStackCap() < 0) {
                tooltip.add("Upgrades:");
            }
            if (barrel.getStackCap() < 0) {
                tooltip.add("- Creative");
            }
            if (barrel.voidOverflow()) {
                tooltip.add("- Void Overflow");
            }
        } else if (crate != null) {
            int stackCap;
            int n = stackCap = crate.getStackCap() >= 0 ? crate.getStackCap() : 32768;
            if (crate.getRefItem().func_190926_b()) {
                tooltip.add("Item: EMPTY" + (crate.isLocked() ? " [LOCKED]" : ""));
                tooltip.add("Amount: " + BdsmWailaHandler.formatValue(crate.getCount()) + " / " + BdsmWailaHandler.formatValue(stackCap * 64));
            } else {
                tooltip.add("Item: " + crate.getRefItem().func_82833_r() + (crate.isLocked() ? " [LOCKED]" : ""));
                tooltip.add("Amount: " + BdsmWailaHandler.formatValue(crate.getCount()) + " / " + BdsmWailaHandler.formatValue(stackCap * crate.getRefItem().func_77976_d()));
            }
            if (crate.voidOverflow() || crate.isOreDict() || crate.getStackCap() < 0) {
                tooltip.add("Upgrades:");
            }
            if (crate.getStackCap() < 0) {
                tooltip.add("- Creative");
            }
            if (crate.isOreDict()) {
                tooltip.add("- Ore Dictionary");
            }
            if (crate.voidOverflow()) {
                tooltip.add("- Void Overflow");
            }
        }
        return tooltip;
    }

    private static String formatValue(long value) {
        String s = "";
        double n = 1.0;
        for (int i = suffixes.length - 1; i >= 0; --i) {
            n = Math.pow(1000.0, i);
            if (!((double)Math.abs(value) >= n)) continue;
            s = suffixes[i];
            break;
        }
        return df.format((double)value / n) + s;
    }
}

