/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.core;

import funwayguy.bdsandm.core.BDSM;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BdsmConfig {
    private static final List<BlacklistEntry> blacklist = new ArrayList<BlacklistEntry>();
    private static final List<String> fluidBlacklist = new ArrayList<String>();
    public static boolean multiPurposeBarrel = true;
    public static final List<String> oreDictBlacklist = new ArrayList<String>();
    public static boolean altControls = false;
    public static int dClickDelay = 5;
    private static Configuration config;

    @SubscribeEvent
    public static void onConfigReload(ConfigChangedEvent event) {
        if (event.getModID().equals("bdsandm")) {
            config.save();
            BdsmConfig.load();
        }
    }

    protected static void setConfig(File file) {
        config = new Configuration(file, true);
    }

    public static Configuration getConfig() {
        return config;
    }

    protected static void load() {
        if (config == null) {
            throw new NullPointerException("Attempted to load configuration file before it was initialised");
        }
        config.load();
        altControls = config.getBoolean("Alternate Controls", "client", false, "Use the old sneak method to extract items (may interfere with block harvesting)");
        dClickDelay = config.getInt("Double Click Delay", "client", 5, 1, 20, "Maximum time in ticks between mouse clicks to be counted as a double click");
        multiPurposeBarrel = config.getBoolean("Multi-Purpose Barrels", "general", true, "Allows items to be placed in barrels. Disable to only permit fluids");
        blacklist.clear();
        for (String s : config.getStringList("Item Blacklist", "general", new String[0], "Blacklist these items from being stored in barrels and crates")) {
            String[] split = s.split(":");
            try {
                if (split.length == 2) {
                    blacklist.add(new BlacklistEntry(new ResourceLocation(split[0], split[1])));
                    continue;
                }
                if (split.length != 3) continue;
                blacklist.add(new BlacklistEntry(new ResourceLocation(split[0], split[1]), Integer.parseInt(split[2])));
            }
            catch (Exception e) {
                BDSM.logger.error("An error occured while parsing blacklist entry", (Throwable)e);
            }
        }
        fluidBlacklist.clear();
        Collections.addAll(fluidBlacklist, config.getStringList("Fluid Blacklist", "general", new String[0], "Blacklist these fluids from being stored in barrels"));
        oreDictBlacklist.clear();
        Collections.addAll(oreDictBlacklist, config.getStringList("Ore Dict Blacklist", "general", new String[0], "Blacklists ore dictionary conversions (REGEX)"));
        config.save();
    }

    public static boolean isBlacklisted(FluidStack fluid) {
        return fluid != null && fluidBlacklist.contains(fluid.getFluid().getName());
    }

    public static boolean isBlacklisted(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (BlacklistEntry entry : blacklist) {
            if (!entry.id.equals((Object)stack.func_77973_b().getRegistryName()) || entry.meta >= 0 && entry.meta != stack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    private static class BlacklistEntry {
        private final ResourceLocation id;
        private final int meta;

        private BlacklistEntry(@Nonnull ResourceLocation res) {
            this(res, -1);
        }

        private BlacklistEntry(@Nonnull ResourceLocation res, int meta) {
            this.id = res;
            this.meta = meta;
        }
    }
}

