/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.blocks.tiles;

import funwayguy.bdsandm.inventory.capability.BdsmCapabilies;
import funwayguy.bdsandm.inventory.capability.CapabilityCrate;
import funwayguy.bdsandm.inventory.capability.ICrateCallback;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityCrate
extends TileEntity
implements ICrateCallback {
    private final CapabilityCrate crateCap;
    private boolean creativeBreak = false;
    private long lastClick = 0L;
    private int clickCount = 0;

    public TileEntityCrate() {
        this.crateCap = new CapabilityCrate(64, 1024).setCallback(this);
    }

    public TileEntityCrate(int initCap, int maxCap) {
        this.crateCap = new CapabilityCrate(initCap, maxCap).setCallback(this);
    }

    public void setCreativeBroken(boolean state) {
        this.creativeBreak = state;
    }

    public boolean isCreativeBroken() {
        return this.creativeBreak;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 1024.0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == BdsmCapabilies.CRATE_CAP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.crateCap);
        }
        if (capability == BdsmCapabilies.CRATE_CAP) {
            return (T)BdsmCapabilies.CRATE_CAP.cast((Object)this.crateCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onCrateChanged() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_70296_d();
        if (this.field_145850_b.func_73046_m() != null) {
            this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.crateCap.deserializeNBT(nbt.func_74775_l("crateCap"));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("crateCap", (NBTBase)this.crateCap.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public int getClickCount(long worldTime, int delay) {
        if (worldTime - this.lastClick <= 1L) {
            return -1;
        }
        if (worldTime - this.lastClick > (long)delay) {
            this.lastClick = worldTime;
            this.clickCount = 0;
            return 0;
        }
        this.lastClick = worldTime;
        return ++this.clickCount;
    }
}

