/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class SmallTunnelStairs
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 9;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 8;
    private static final int LOCAL_Z_END = 4;

    public SmallTunnelStairs() {
    }

    public SmallTunnelStairs(int i, int chunkPieceLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, chunkPieceLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 5, 9, 5, direction);
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        EnumFacing direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c - 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78892_f + 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78892_f, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, direction, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 4)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 4, 8, 4, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 0, 4, this.getFloorSelector());
        for (int i = 0; i < 5; ++i) {
            this.fill(world, box, 1, i + 1, i, 3, i + 1 + 2, i, AIR);
            this.chanceReplaceNonAir(world, box, random, 0.5f, 1, i, i, 3, i, i, this.getMainSelector());
            this.replaceAir(world, box, 1, i, i, 3, i, i, this.getMainBlock());
            if (i == 4) {
                this.func_175811_a(world, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH), 2, i + 1, i, box);
                continue;
            }
            this.func_175811_a(world, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH), 2, i + 1, i, box);
        }
        this.addBiomeDecorations(world, box, random, 1, 0, 0, 3, 7, 4);
        this.addVines(world, box, random, 1, 0, 1, 3, 8, 3);
        return true;
    }
}

