/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.util;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BlockSetSelector {
    private Map<IBlockState, Float> entries = new HashMap<IBlockState, Float>();
    private IBlockState defaultBlock = Blocks.field_150350_a.func_176223_P();

    public BlockSetSelector(IBlockState defaultBlock) {
        this.defaultBlock = defaultBlock;
    }

    public BlockSetSelector() {
    }

    public static BlockSetSelector from(IBlockState ... blockStates) {
        BlockSetSelector selector = new BlockSetSelector();
        float chance = 1.0f / (float)blockStates.length;
        for (IBlockState state : blockStates) {
            selector.addBlock(state, chance);
        }
        return selector;
    }

    public BlockSetSelector addBlock(IBlockState blockState, float chance) {
        for (Map.Entry<IBlockState, Float> entry : this.entries.entrySet()) {
            if (entry.getKey() != blockState) continue;
            BetterMineshafts.LOGGER.warn(String.format("WARNING: duplicate block %s added to BlockSelector!", blockState.toString()));
            return this;
        }
        float currTotal = this.entries.values().stream().reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            BetterMineshafts.LOGGER.warn(String.format("WARNING: block %s added to BlockSelector exceeds max probabiltiy of 1!", blockState.toString()));
            return this;
        }
        this.entries.put(blockState, Float.valueOf(chance));
        return this;
    }

    public IBlockState get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Map.Entry<IBlockState, Float> entry : this.entries.entrySet()) {
            float chance = entry.getValue().floatValue();
            if (currBottom <= target && target < currBottom + chance) {
                return entry.getKey();
            }
            currBottom += chance;
        }
        return this.defaultBlock;
    }

    public void setDefaultBlock(IBlockState blockState) {
        this.defaultBlock = blockState;
    }
}

