/*
 * Decompiled with CFR 0.152.
 */
package squeek.hungerinpeace;

import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.HungerRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;
import squeek.hungerinpeace.ModConfig;

@Mod(modid="hungerinpeace", version="1.0.0", dependencies="required-after:applecore", acceptedMinecraftVersions="[1.12]")
public class HungerInPeace {
    public static final Logger LOG = LogManager.getLogger((String)"hungerinpeace");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModConfig.init(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FMLInterModComms.sendRuntimeMessage((Object)"hungerinpeace", (String)"VersionChecker", (String)"addVersionCheck", (String)"http://www.ryanliptak.com/minecraft/versionchecker/squeek502/HungerInPeace");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExhausted(ExhaustionEvent.Exhausted event) {
        if (event.player.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            return;
        }
        if (event.player.func_71024_bL().func_75115_e() <= 0.0f) {
            event.deltaHunger = -1;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPeacefulRegen(HealthRegenEvent.PeacefulRegen event) {
        if (!ModConfig.DISABLE_HEALTH_REGEN) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPeacefulHungerRegen(HungerRegenEvent.PeacefulRegen event) {
        if (!ModConfig.DISABLE_HUNGER_REGEN) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onStarve(StarvationEvent.Starve event) {
        if (event.starveDamage != 0.0f) {
            return;
        }
        if (event.player.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            return;
        }
        if (event.player.func_110143_aJ() <= ModConfig.MIN_HEALTH_FROM_STARVATION) {
            return;
        }
        event.starveDamage = 1.0f;
    }
}

