/*
 * Decompiled with CFR 0.152.
 */
package com.hjae.findme.proxy;

import com.hjae.findme.FindMe;
import com.hjae.findme.network.FluidPositionRequestMessage;
import com.hjae.findme.network.PositionRequestMessage;
import com.hjae.findme.proxy.CommonProxy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import mezz.jei.Internal;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.InputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    public static KeyBinding KEY_ITEM = new KeyBinding("key.findme.search", 21, "key.findme.category");
    public static KeyBinding KEY_FLUIDS = new KeyBinding("key.findme.search_fluids", 20, "key.findme.category");
    private ItemStack stack = ItemStack.field_190927_a;
    private static Method getIngredientUnderMouseForKey;
    private static InputHandler inputHandler;
    private static Field inputHandlerField;

    @Override
    public void preinit(FMLPreInitializationEvent event) {
        super.preinit(event);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_ITEM);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        try {
            getIngredientUnderMouseForKey = InputHandler.class.getDeclaredMethod("getIngredientUnderMouseForKey", Integer.TYPE, Integer.TYPE);
            inputHandlerField = Internal.class.getDeclaredField("inputHandler");
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            FindMe.logger.error("Error during reflection of JEI");
        }
        getIngredientUnderMouseForKey.setAccessible(true);
        inputHandlerField.setAccessible(true);
        try {
            inputHandler = (InputHandler)inputHandlerField.get(Internal.class);
        }
        catch (IllegalAccessException e) {
            FindMe.logger.error((Object)e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(RenderTooltipEvent.Pre event) {
        this.stack = event.getStack();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.stack = ItemStack.field_190927_a;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void keyPress(GuiScreenEvent.KeyboardInputEvent.Post event) {
        boolean items = KEY_ITEM.isActiveAndMatches(Keyboard.getEventKey());
        boolean fluids = KEY_FLUIDS.isActiveAndMatches(Keyboard.getEventKey());
        if (Keyboard.getEventKeyState() && (items || fluids) && Minecraft.func_71410_x().field_71462_r != null) {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (!this.stack.func_190926_b()) {
                FluidStack fluidStack;
                IFluidHandlerItem fluidHandler;
                if (items) {
                    FindMe.NETWORK.sendToServer((IMessage)new PositionRequestMessage(this.stack));
                } else if (this.stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fluidHandler = (IFluidHandlerItem)this.stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (fluidStack = fluidHandler.drain(Integer.MAX_VALUE, false)) != null) {
                    FindMe.NETWORK.sendToServer((IMessage)new FluidPositionRequestMessage(fluidStack));
                }
            }
            if (screen instanceof GuiContainer) {
                ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
                int i1 = scaledresolution.func_78326_a();
                int j1 = scaledresolution.func_78328_b();
                int x = Mouse.getX() * i1 / Minecraft.func_71410_x().field_71443_c;
                int y = j1 - Mouse.getY() * j1 / Minecraft.func_71410_x().field_71440_d - 1;
                Object o = null;
                try {
                    o = getIngredientUnderMouseForKey.invoke((Object)inputHandler, x, y);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    FindMe.logger.error("Error during reflection of getIngredientUnderMouseForKey" + e);
                }
                if (o != null) {
                    if (items && ((ClickedIngredient)o).getValue() instanceof ItemStack) {
                        FindMe.NETWORK.sendToServer((IMessage)new PositionRequestMessage((ItemStack)((ClickedIngredient)o).getValue()));
                    } else if (fluids && ((ClickedIngredient)o).getValue() instanceof FluidStack) {
                        FindMe.NETWORK.sendToServer((IMessage)new FluidPositionRequestMessage((FluidStack)((ClickedIngredient)o).getValue()));
                    }
                }
            }
        }
    }
}

