/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity.logic;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import pcl.opensecurity.Config;
import pcl.opensecurity.common.SoundHandler;
import pcl.opensecurity.common.blocks.BlockEnergyTurret;
import pcl.opensecurity.common.entity.EntityEnergyBolt;
import pcl.opensecurity.common.tileentity.TileEntityEnergyTurret;
import pcl.opensecurity.common.tileentity.logic.EnergyTurretStats;

public class EnergyTurret {
    private static final float maxShaftLengthForOneBlock = 0.5f;
    private ItemStackHandler inventory;
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private float setpointYaw = 0.0f;
    private float setpointPitch = 0.0f;
    private float shaft = 1.0f;
    private float setShaft = 1.0f;
    private float barrel = 1.0f;
    private int tickCool = 0;
    private boolean power = false;
    private boolean armed = false;
    private EnumFacing mountedDirection;
    private EnergyTurretStats energyTurretStats = new EnergyTurretStats();
    private TileEntityEnergyTurret tile;

    public EnergyTurret(@Nonnull TileEntityEnergyTurret energyTurretHost) {
        this.tile = energyTurretHost;
        this.inventory = new ItemStackHandler(8){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public void onContentsChanged(int slot) {
                EnergyTurret.this.stats().loadFromInventory(EnergyTurret.this.inventory);
            }
        };
    }

    public void onLoad() {
        this.stats().loadFromInventory(this.inventory);
    }

    private boolean isShaftLengthValid() {
        float maxShaft = this.getMaxAvailableShaftLength(this.shaft);
        if (this.setShaft > maxShaft) {
            this.setShaft(maxShaft);
        }
        return !(this.getShaftLength() > maxShaft);
    }

    public void update() {
        boolean moveSound = false;
        if (this.isPowered() && !this.tile.consumeEnergy(10.0)) {
            this.setPowered(false);
        }
        this.tickCool -= this.energyTurretStats.getCooldown();
        float tmpSetPitch = this.setpointPitch;
        float ms = 0.0f;
        float my = 0.0f;
        float mp = 0.0f;
        float movePerTick = 4.0f + this.energyTurretStats.getMoveSpeed();
        if (this.isPowered() || !this.isShaftLengthValid()) {
            float ds = this.setShaft - this.shaft;
            ms = Math.min(0.05f, Math.abs(ds));
            this.shaft += ms * Math.signum(ds);
            if (Float.isNaN(this.shaft) || Float.isInfinite(this.shaft)) {
                this.shaft = 0.0f;
            }
            if (ms > 0.0f) {
                moveSound = true;
            }
        }
        if (this.isPowered()) {
            float dy;
            if (Float.isNaN(this.setpointYaw) || Float.isInfinite(this.setpointYaw)) {
                this.setpointYaw = this.yaw;
            }
            if ((dy = (this.setpointYaw - this.yaw) % 360.0f) > 180.0f) {
                dy -= 360.0f;
            } else if (dy < -180.0f) {
                dy = 360.0f + dy;
            }
            my = Math.min(movePerTick, Math.abs(dy));
            this.yaw += my * Math.signum(dy);
            while (this.yaw < 0.0f) {
                this.yaw += 360.0f;
            }
            this.yaw %= 360.0f;
            if (Float.isNaN(this.yaw) || Float.isInfinite(this.yaw)) {
                this.yaw = 0.0f;
            }
            if (my > 0.0f) {
                moveSound = true;
            }
        } else {
            tmpSetPitch = -90.0f;
            movePerTick = 6.0f;
        }
        if (this.isUpright()) {
            tmpSetPitch = Math.min(tmpSetPitch, (float)(Math.atan(this.shaft) * 360.0 / Math.PI));
            tmpSetPitch = Math.max(tmpSetPitch, (float)(-Math.atan(this.shaft) * 180.0 / Math.PI));
        } else {
            tmpSetPitch = Math.min(tmpSetPitch, (float)(Math.atan(this.shaft) * 180.0 / Math.PI));
            tmpSetPitch = Math.max(tmpSetPitch, (float)(-Math.atan(this.shaft) * 360.0 / Math.PI));
        }
        if (Float.isNaN(tmpSetPitch) || Float.isInfinite(tmpSetPitch)) {
            tmpSetPitch = this.pitch;
        }
        float dp = tmpSetPitch - this.pitch;
        mp = Math.min(movePerTick, Math.abs(dp));
        if (this.power && mp > 0.0f) {
            moveSound = true;
        }
        this.pitch += mp * Math.signum(dp);
        this.pitch = Math.min(90.0f, Math.max(-90.0f, this.pitch));
        if (Float.isNaN(this.pitch) || Float.isInfinite(this.pitch)) {
            this.pitch = 0.0f;
        }
        if (this.isPowered()) {
            if (this.isArmed()) {
                if (this.barrel < 1.0f) {
                    this.barrel = Math.min(1.0f, this.barrel + 0.1f);
                    moveSound = true;
                }
            } else if (this.barrel > 0.0f) {
                this.barrel = Math.max(0.0f, this.barrel - 0.1f);
                moveSound = true;
            }
        }
        this.tile.setShouldPlay(moveSound);
    }

    private EnergyTurretStats stats() {
        return this.energyTurretStats;
    }

    public boolean isUpright() {
        if (this.mountedDirection == null && this.getWorld() != null) {
            this.mountedDirection = BlockEnergyTurret.getMount(this.getWorld().func_180495_p(this.getPos()));
        }
        return EnumFacing.DOWN.equals((Object)this.mountedDirection);
    }

    public float getRealYaw() {
        if (Config.getConfig().getCategory("general").get("turretReverseRotation").getBoolean()) {
            return (float)Math.PI * (0.0f - this.yaw) / 180.0f;
        }
        return (float)Math.PI * this.yaw / 180.0f;
    }

    public float getRealPitch() {
        return (float)Math.PI * this.pitch / 180.0f;
    }

    private boolean canExtendShaft() {
        BlockPos otherBlock = this.getPos().func_177982_a(0, this.isUpright() ? 1 : -1, 0);
        return otherBlock.func_177956_o() < 0 || otherBlock.func_177956_o() > 255 || this.getWorld().func_175623_d(otherBlock);
    }

    private float getMaxAvailableShaftLength(float newExt) {
        return (newExt = Math.max(0.0f, Math.min(newExt, 2.0f))) <= 0.5f ? newExt : 0.5f;
    }

    public float setShaft(float newlen) {
        if (this.setShaft != (newlen = Math.max(0.0f, Math.min(newlen, this.getMaxAvailableShaftLength(newlen))))) {
            this.setShaft = newlen;
            this.tile.markDirtyClient();
        }
        return newlen;
    }

    public float getShaftLength() {
        return this.shaft;
    }

    public float getBarrel() {
        return this.barrel;
    }

    public void setYawPitch(float newYaw, float newPitch) {
        while (newYaw < 0.0f) {
            newYaw += 360.0f;
        }
        this.setpointYaw = Math.max(0.0f, Math.min(newYaw % 360.0f, 360.0f));
        this.setpointPitch = Math.max(-90.0f, Math.min(newPitch, 90.0f));
        this.tile.markDirtyClient();
    }

    private boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean val) {
        if (this.armed == val) {
            return;
        }
        this.armed = val;
        this.tile.markDirtyClient();
    }

    public void setPowered(boolean powered) {
        if (this.power == powered) {
            return;
        }
        this.power = powered;
        if (!powered) {
            this.setShaft(this.shaft);
            this.setYawPitch(0.0f, 0.0f);
        }
        this.tile.markDirtyClient();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public float yaw() {
        return this.yaw;
    }

    public float pitch() {
        return this.pitch;
    }

    public boolean isReady() {
        return this.tickCool <= 0 && this.armed && this.barrel == 1.0f;
    }

    public boolean isPowered() {
        return this.power;
    }

    public Object[] isOnTarget() {
        double delta = Math.abs(this.pitch - this.setpointPitch) + Math.abs(this.yaw - this.setpointYaw);
        return new Object[]{delta < 0.5, delta};
    }

    public Object[] fire() {
        if (!this.isPowered()) {
            return new Object[]{false, "powered off"};
        }
        if (!this.isArmed() || this.barrel < 1.0f) {
            return new Object[]{false, "not armed"};
        }
        if (this.tickCool > 0) {
            return new Object[]{false, "gun hasn't cooled"};
        }
        if (!this.tile.consumeEnergy(this.energyTurretStats.getEnergyUsage())) {
            return new Object[]{false, "not enough energy"};
        }
        this.tickCool = 100;
        float p = this.getRealPitch();
        float a = this.getRealYaw() + (float)Math.PI;
        EntityEnergyBolt bolt = new EntityEnergyBolt(this.getWorld());
        float dY = 0.5f + (this.isUpright() ? 1.0f : -1.0f) * (0.125f + this.shaft * 0.375f);
        bolt.setHeading(a, p);
        bolt.setDamage(this.energyTurretStats.getDamage());
        bolt.func_70107_b((float)this.getPos().func_177958_n() + 0.5f, (float)this.getPos().func_177956_o() + dY, (float)this.getPos().func_177952_p() + 0.5f);
        this.tile.markDirtyClient();
        this.getWorld().func_184133_a(null, this.getPos(), SoundHandler.turretFire, SoundCategory.BLOCKS, 15.5f, 1.0f);
        this.getWorld().func_72838_d((Entity)bolt);
        return new Object[]{true};
    }

    private World getWorld() {
        return this.tile.func_145831_w();
    }

    private BlockPos getPos() {
        return this.tile.func_174877_v();
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.power = tag.func_74767_n("powered");
        this.armed = tag.func_74767_n("armed");
        this.yaw = tag.func_74760_g("yaw");
        this.setpointYaw = tag.func_74760_g("syaw");
        this.pitch = tag.func_74760_g("pitch");
        this.setpointPitch = tag.func_74760_g("spitch");
        this.shaft = tag.func_74760_g("shaft");
        this.setShaft = tag.func_74760_g("sshaft");
        this.barrel = tag.func_74760_g("barrel");
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("powered", this.power);
        tag.func_74757_a("armed", this.armed);
        tag.func_74776_a("yaw", this.yaw);
        tag.func_74776_a("syaw", this.setpointYaw);
        tag.func_74776_a("pitch", this.pitch);
        tag.func_74776_a("spitch", this.setpointPitch);
        tag.func_74776_a("shaft", this.shaft);
        tag.func_74776_a("sshaft", this.setShaft);
        tag.func_74776_a("barrel", this.barrel);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }
}

