/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.google.common.collect.HashMultimap;
import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.misc.NNLUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ItemHandUpgrade
extends ItemCyberware
implements IMenuItem {
    public static final int META_CRAFT_HANDS = 0;
    public static final int META_CLAWS = 1;
    public static final int META_MINING = 2;
    private static Item itemTool;
    private static final UUID uuidClawsDamageAttribute;
    private static final HashMultimap<String, AttributeModifier> multimapClawsDamageAttribute;
    private static final Map<UUID, Boolean> lastClaws;
    public static float clawsTime;
    private static final float[] f;

    public ItemHandUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> required(ItemStack stack) {
        return NNLUtil.fromArray(new ItemStack[][]{{CyberwareContent.cyberlimbs.getCachedStack(0), CyberwareContent.cyberlimbs.getCachedStack(1)}});
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == this;
    }

    private ItemStack getItemStackTool() {
        if (itemTool == null) {
            Item itemConfig = Item.func_111206_d((String)CyberwareConfig.FIST_MINING_TOOL_NAME);
            if (itemConfig == null) {
                Cyberware.logger.error(String.format("Unable to find item with id %s, check your configuration. Defaulting fist mining tool to Iron pickaxe.", CyberwareConfig.FIST_MINING_TOOL_NAME));
                itemConfig = Items.field_151035_b;
            }
            itemTool = itemConfig;
        }
        return new ItemStack(itemTool);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackClaws = cyberwareUserData.getCyberware(this.getCachedStack(1));
        if (!itemStackClaws.func_190926_b()) {
            boolean isEquipped;
            boolean wasEquipped = this.getLastClaws(entityLivingBase);
            boolean bl = entityLivingBase.func_184614_ca().func_190926_b() && (entityLivingBase.func_184591_cq() == EnumHandSide.RIGHT ? cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(1)) : cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(0))) && EnableDisableHelper.isEnabled(itemStackClaws) ? true : (isEquipped = false);
            if (isEquipped) {
                if (!wasEquipped || entityLivingBase.field_70173_aa % 20 == 0) {
                    this.addClawsDamage(entityLivingBase);
                    lastClaws.put(entityLivingBase.func_110124_au(), Boolean.TRUE);
                }
                if (!wasEquipped && entityLivingBase.func_130014_f_().field_72995_K) {
                    this.updateHand(entityLivingBase, true);
                }
            } else if (wasEquipped || entityLivingBase.field_70173_aa % 20 == 0) {
                this.removeClawsDamage(entityLivingBase);
                lastClaws.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
            }
        } else if (entityLivingBase.field_70173_aa % 20 == 0) {
            this.removeClawsDamage(entityLivingBase);
            lastClaws.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
    }

    private void updateHand(EntityLivingBase entityLivingBase, boolean delay) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && entityLivingBase == Minecraft.func_71410_x().field_71439_g) {
            clawsTime = Minecraft.func_71410_x().func_184121_ak() + (float)entityLivingBase.field_70173_aa + (float)(delay ? 5 : 0);
        }
    }

    private boolean getLastClaws(EntityLivingBase entityLivingBase) {
        if (!lastClaws.containsKey(entityLivingBase.func_110124_au())) {
            lastClaws.put(entityLivingBase.func_110124_au(), Boolean.FALSE);
        }
        return lastClaws.get(entityLivingBase.func_110124_au());
    }

    private void addClawsDamage(EntityLivingBase entityLivingBase) {
        entityLivingBase.func_110140_aT().func_111147_b(multimapClawsDamageAttribute);
    }

    private void removeClawsDamage(EntityLivingBase entityLivingBase) {
        entityLivingBase.func_110140_aT().func_111148_a(multimapClawsDamageAttribute);
    }

    @Override
    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            this.removeClawsDamage(entityLivingBase);
        }
    }

    @SubscribeEvent
    public void handleMining(PlayerEvent.HarvestCheck event) {
        ItemStack itemStackTool;
        boolean rightArm;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackMining = cyberwareUserData.getCyberware(this.getCachedStack(2));
        boolean bl = rightArm = entityPlayer.func_184591_cq() == EnumHandSide.RIGHT ? cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(1)) : cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(0));
        if (rightArm && !itemStackMining.func_190926_b() && entityPlayer.func_184614_ca().func_190926_b() && (itemStackTool = this.getItemStackTool()).func_150998_b(event.getTargetBlock())) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void handleMineSpeed(PlayerEvent.BreakSpeed event) {
        boolean rightArm;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackMining = cyberwareUserData.getCyberware(this.getCachedStack(2));
        boolean bl = rightArm = entityPlayer.func_184591_cq() == EnumHandSide.RIGHT ? cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(1)) : cyberwareUserData.isCyberwareInstalled(CyberwareContent.cyberlimbs.getCachedStack(0));
        if (rightArm && !itemStackMining.func_190926_b() && entityPlayer.func_184614_ca().func_190926_b()) {
            ItemStack itemStackTool = this.getItemStackTool();
            event.setNewSpeed(event.getNewSpeed() * itemStackTool.func_150997_a(entityPlayer.field_70170_p.func_180495_p(event.getPos())));
        }
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @Override
    public void use(Entity entity, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
        if (entity instanceof EntityLivingBase && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.updateHand((EntityLivingBase)entity, false);
        }
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }

    static {
        uuidClawsDamageAttribute = UUID.fromString("63c32801-94fb-40d4-8bd2-89135c1e44b1");
        lastClaws = new HashMap<UUID, Boolean>();
        multimapClawsDamageAttribute = HashMultimap.create();
        multimapClawsDamageAttribute.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuidClawsDamageAttribute, "Claws damage upgrade", 5.5, 0));
        f = new float[]{1.0f, 0.0f, 0.0f};
    }
}

