/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.CyberwareHudDataEvent;
import flaxbeard.cyberware.api.hud.CyberwareHudEvent;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.api.hud.NotificationInstance;
import flaxbeard.cyberware.api.item.IHudjack;
import flaxbeard.cyberware.client.KeyBinds;
import flaxbeard.cyberware.client.gui.GuiHudConfiguration;
import flaxbeard.cyberware.client.gui.hud.MissingPowerDisplay;
import flaxbeard.cyberware.client.gui.hud.NotificationDisplay;
import flaxbeard.cyberware.client.gui.hud.PowerDisplay;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HudHandler {
    public static final HudHandler INSTANCE = new HudHandler();
    public static final ResourceLocation HUD_TEXTURE = new ResourceLocation("cyberware:textures/gui/hud.png");
    public static Stack<NotificationInstance> notifications = new NotificationStack<NotificationInstance>(5);
    private static PowerDisplay powerDisplay = new PowerDisplay();
    private static MissingPowerDisplay missingPowerDisplay = new MissingPowerDisplay();
    private static NotificationDisplay notificationDisplay = new NotificationDisplay();
    private int cache_tickExisted = 0;
    private float cache_floatingFactor = 0.0f;
    private List<IHudElement> cache_hudElements = new ArrayList<IHudElement>();
    private boolean cache_isHUDjackAvailable = false;
    private boolean cache_promptToOpenMenu = false;
    private int cache_hudColorHex = 65535;
    private int lastTickExisted = 0;
    private double lastVelX = 0.0;
    private double lastVelY = 0.0;
    private double lastVelZ = 0.0;
    private double lastLastVelX = 0.0;
    private double lastLastVelY = 0.0;
    private double lastLastVelZ = 0.0;

    public static void addNotification(NotificationInstance notification) {
        notifications.push(notification);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addHudElements(CyberwareHudEvent event) {
        if (event.isHudjackAvailable()) {
            event.addElement(powerDisplay);
            event.addElement(missingPowerDisplay);
            event.addElement(notificationDisplay);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void saveHudElements(CyberwareHudDataEvent event) {
        event.addElement(powerDisplay);
        event.addElement(missingPowerDisplay);
        event.addElement(notificationDisplay);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRender(@Nonnull RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT) {
            this.drawHUD(event.getResolution(), event.getPartialTicks());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawHUD(ScaledResolution scaledResolution, float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP entityPlayerSP = mc.field_71439_g;
        if (entityPlayerSP == null) {
            return;
        }
        if (entityPlayerSP.field_70173_aa != this.cache_tickExisted) {
            this.cache_tickExisted = entityPlayerSP.field_70173_aa;
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayerSP);
            if (cyberwareUserData == null) {
                return;
            }
            this.cache_floatingFactor = 0.0f;
            boolean isHUDjackAvailable = false;
            List<ItemStack> listHUDjackItems = cyberwareUserData.getHudjackItems();
            for (ItemStack stack : listHUDjackItems) {
                if (!((IHudjack)((Object)CyberwareAPI.getCyberware(stack))).isActive(stack)) continue;
                isHUDjackAvailable = true;
                if (!CyberwareConfig.ENABLE_FLOAT) break;
                if (CyberwareAPI.getCyberware(stack) == CyberwareContent.eyeUpgrades) {
                    this.cache_floatingFactor = CyberwareConfig.HUDLENS_FLOAT;
                    break;
                }
                this.cache_floatingFactor = CyberwareConfig.HUDJACK_FLOAT;
                break;
            }
            CyberwareHudEvent hudEvent = new CyberwareHudEvent(scaledResolution, isHUDjackAvailable);
            MinecraftForge.EVENT_BUS.post((Event)hudEvent);
            this.cache_hudElements = hudEvent.getElements();
            this.cache_isHUDjackAvailable = hudEvent.isHudjackAvailable();
            this.cache_promptToOpenMenu = cyberwareUserData.getActiveItems().size() > 0 && !cyberwareUserData.hasOpenedRadialMenu();
            this.cache_hudColorHex = cyberwareUserData.getHudColorHex();
        }
        GlStateManager.func_179094_E();
        double accelLastY = this.lastVelY - this.lastLastVelY;
        double accelY = entityPlayerSP.field_70181_x - this.lastVelY;
        double accelPitch = accelLastY + (accelY - accelLastY) * (double)(partialTick + (float)entityPlayerSP.field_70173_aa - (float)this.lastTickExisted) / 2.0;
        double pitchCameraMove = this.cache_floatingFactor * (entityPlayerSP.field_71164_i + (entityPlayerSP.field_71155_g - entityPlayerSP.field_71164_i) * partialTick - entityPlayerSP.field_70125_A);
        double yawCameraMove = this.cache_floatingFactor * (entityPlayerSP.field_71163_h + (entityPlayerSP.field_71154_f - entityPlayerSP.field_71163_h) * partialTick - entityPlayerSP.field_70177_z);
        GlStateManager.func_179137_b((double)yawCameraMove, (double)(pitchCameraMove + accelPitch * 50.0 * (double)this.cache_floatingFactor), (double)0.0);
        if (entityPlayerSP.field_70173_aa > this.lastTickExisted + 1) {
            this.lastTickExisted = entityPlayerSP.field_70173_aa;
            this.lastLastVelX = this.lastVelX;
            this.lastLastVelY = this.lastVelY;
            this.lastLastVelZ = this.lastVelZ;
            this.lastVelX = entityPlayerSP.field_70159_w;
            this.lastVelY = entityPlayerSP.field_70181_x;
            this.lastVelZ = entityPlayerSP.field_70179_y;
        }
        for (IHudElement hudElement : this.cache_hudElements) {
            if (hudElement.getHeight() + GuiHudConfiguration.getAbsoluteY(scaledResolution, hudElement) <= 3) {
                GuiHudConfiguration.setYFromAbsolute(scaledResolution, hudElement, 0 - hudElement.getHeight() + 4);
            }
            if (GuiHudConfiguration.getAbsoluteY(scaledResolution, hudElement) >= scaledResolution.func_78328_b() - 3) {
                GuiHudConfiguration.setYFromAbsolute(scaledResolution, hudElement, scaledResolution.func_78328_b() - 4);
            }
            if (hudElement.getWidth() + GuiHudConfiguration.getAbsoluteX(scaledResolution, hudElement) <= 3) {
                GuiHudConfiguration.setXFromAbsolute(scaledResolution, hudElement, 0 - hudElement.getWidth() + 4);
            }
            if (GuiHudConfiguration.getAbsoluteX(scaledResolution, hudElement) >= scaledResolution.func_78326_a() - 3) {
                GuiHudConfiguration.setXFromAbsolute(scaledResolution, hudElement, scaledResolution.func_78326_a() - 4);
            }
            hudElement.render((EntityPlayer)entityPlayerSP, scaledResolution, this.cache_isHUDjackAvailable, mc.field_71462_r instanceof GuiHudConfiguration, partialTick);
        }
        if (this.cache_promptToOpenMenu) {
            String textOpenMenu = I18n.func_135052_a((String)"cyberware.gui.open_menu", (Object[])new Object[]{KeyBinds.menu.getDisplayName()});
            FontRenderer fontRenderer = mc.field_71466_p;
            fontRenderer.func_175063_a(textOpenMenu, (float)(scaledResolution.func_78326_a() - fontRenderer.func_78256_a(textOpenMenu) - 5), 5.0f, this.cache_hudColorHex);
        }
        GlStateManager.func_179121_F();
    }

    static {
        notificationDisplay.setHorizontalAnchor(IHudElement.EnumAnchorHorizontal.LEFT);
        notificationDisplay.setVerticalAnchor(IHudElement.EnumAnchorVertical.BOTTOM);
    }

    private static class NotificationStack<T>
    extends Stack<T> {
        private int maxSize;

        public NotificationStack(int size) {
            this.maxSize = size;
        }

        @Override
        public T push(T object) {
            while (this.size() >= this.maxSize) {
                this.remove(0);
            }
            return super.push(object);
        }
    }
}

