/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common;

import com.google.common.collect.Multimap;
import flaxbeard.cyberware.Cyberware;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public enum ArmorClass {
    NONE,
    LIGHT,
    HEAVY;

    static boolean enableLogging;
    static long timeLastLog_ms;
    static int maxEntityArmor;
    static EntityEquipmentSlot[] armorSlots;
    static double[] maxPartArmors;

    public static boolean isWearingLightOrNone(EntityLivingBase entityLivingBase) {
        return ArmorClass.get(entityLivingBase) != HEAVY;
    }

    public static ArmorClass get(@Nonnull EntityLivingBase entityLivingBase) {
        int entityArmor;
        long timeCurrent_ms;
        boolean isLogging = false;
        if (enableLogging && (timeCurrent_ms = System.currentTimeMillis()) > timeLastLog_ms + 2000L) {
            timeLastLog_ms = timeCurrent_ms;
            isLogging = true;
        }
        if ((entityArmor = entityLivingBase.func_70658_aO()) > maxEntityArmor) {
            if (isLogging) {
                Cyberware.logger.warn(String.format("Total armor %d is greater than %d => this is HEAVY armor", entityArmor, maxEntityArmor));
            }
            return HEAVY;
        }
        boolean hasNoArmor = true;
        for (EntityEquipmentSlot entityEquipmentSlot : armorSlots) {
            double maxChestplateArmor;
            ItemArmor itemArmor;
            int damageReductionChestplate;
            ItemStack itemStack = entityLivingBase.func_184582_a(entityEquipmentSlot);
            if (itemStack.func_190926_b()) continue;
            hasNoArmor = false;
            double maxPartArmor = maxPartArmors[entityEquipmentSlot.func_188454_b()];
            if (itemStack.func_77973_b() instanceof ISpecialArmor) {
                ISpecialArmor.ArmorProperties armorProperties = ((ISpecialArmor)itemStack.func_77973_b()).getProperties(entityLivingBase, itemStack, DamageSource.field_76367_g, 1.0, 1);
                if (armorProperties.AbsorbRatio * 25.0 > maxPartArmor) {
                    if (isLogging) {
                        Cyberware.logger.warn(String.format("ISpecialArmor absorption %.1f is greater than %.1f (%.1f) => this is HEAVY armor", armorProperties.AbsorbRatio, 25.0 / maxPartArmor, maxPartArmor));
                    }
                    return HEAVY;
                }
            }
            if (itemStack.func_77973_b() instanceof ItemArmor && (double)(damageReductionChestplate = (itemArmor = (ItemArmor)itemStack.func_77973_b()).func_82812_d().func_78044_b(EntityEquipmentSlot.CHEST)) > (maxChestplateArmor = maxPartArmors[EntityEquipmentSlot.CHEST.func_188454_b()])) {
                if (isLogging) {
                    Cyberware.logger.warn(String.format("ItemArmor material chestplate armor %d is greater then %.1f => this is HEAVY armor", damageReductionChestplate, maxChestplateArmor));
                }
                return HEAVY;
            }
            Multimap attributeModifiers = itemStack.func_111283_C(entityEquipmentSlot);
            for (Map.Entry entry : attributeModifiers.entries()) {
                double armorValue;
                if (!((String)entry.getKey()).equals(SharedMonsterAttributes.field_188791_g.func_111108_a()) || !((armorValue = ((AttributeModifier)entry.getValue()).func_111164_d()) > maxPartArmor)) continue;
                if (isLogging) {
                    Cyberware.logger.warn(String.format("Armor attribute %.1f is greater then %.1f => this is HEAVY armor", armorValue, maxPartArmor));
                }
                return HEAVY;
            }
        }
        if (isLogging) {
            Cyberware.logger.warn(String.format("No heavy armor detected, hasNoArmor is %s", hasNoArmor));
        }
        return hasNoArmor ? NONE : LIGHT;
    }

    static {
        enableLogging = false;
        maxEntityArmor = 10;
        armorSlots = new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.HEAD};
        maxPartArmors = new double[]{1.5, 3.0, 4.0, 1.5};
    }
}

