/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui.hud;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.HudElementBase;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.handler.HudHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MissingPowerDisplay
extends HudElementBase {
    private static final List<ItemStack> exampleStacks = new ArrayList<ItemStack>();

    public MissingPowerDisplay() {
        super("cyberware:missing_power");
        this.setDefaultX(-15);
        this.setDefaultY(35);
        this.setWidth(36);
        this.setHeight(144);
    }

    @Override
    public void renderElement(int x, int y, EntityPlayer entityPlayer, ScaledResolution resolution, boolean isHUDjackAvailable, boolean isConfigOpen, float partialTicks) {
        if (this.isHidden() || !isHUDjackAvailable) {
            return;
        }
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return;
        }
        boolean isRightAnchored = this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
        float currTime = (float)entityPlayer.field_70173_aa + partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        List<ItemStack> stacksPowerOutage = isConfigOpen ? exampleStacks : cyberwareUserData.getPowerOutages();
        List<Integer> timesPowerOutage = cyberwareUserData.getPowerOutageTimes();
        ArrayList<Integer> indexesElapsed = new ArrayList<Integer>();
        float zLevelSaved = renderItem.field_77023_b;
        renderItem.field_77023_b = -300.0f;
        int xPosition = x - 1 + (isRightAnchored ? 0 : 20);
        int yPosition = y;
        for (int index = stacksPowerOutage.size() - 1; index >= 0; --index) {
            ItemStack stack = stacksPowerOutage.get(index);
            if (stack.func_190926_b()) continue;
            int time = (int)currTime;
            if (isConfigOpen) {
                if (index == 0) {
                    time = (int)(currTime - 20.0f - (float)(entityPlayer.field_70173_aa % 40));
                }
            } else {
                time = timesPowerOutage.get(index);
            }
            if (entityPlayer.field_70173_aa - time < 50) {
                double percentVisible = Math.max(0.0f, (currTime - (float)time - 20.0f) / 30.0f);
                float xOffset = (float)(20.0 * Math.sin(percentVisible * Math.PI / 2.0));
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(isRightAnchored ? xOffset : -xOffset), (float)0.0f, (float)0.0f);
                fontRenderer.func_175063_a("!", (float)(xPosition + 14), (float)(yPosition + 8), 0xFF0000);
                RenderHelper.func_74519_b();
                renderItem.func_180450_b(stack, xPosition, yPosition);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
                yPosition += 18;
                continue;
            }
            if (isConfigOpen) continue;
            indexesElapsed.add(index);
        }
        renderItem.field_77023_b = zLevelSaved;
        Iterator iterator = indexesElapsed.iterator();
        while (iterator.hasNext()) {
            int indexElapsed = (Integer)iterator.next();
            stacksPowerOutage.remove(indexElapsed);
            timesPowerOutage.remove(indexElapsed);
        }
        GlStateManager.func_179121_F();
    }

    static {
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
    }
}

