/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.gregicprobe.integration.gregtech;

import gregtech.api.GTValues;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CableTileInfoProvider
implements IProbeInfoProvider {
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, EntityPlayer entityPlayer, World world, IBlockState iBlockState, IProbeHitData iProbeHitData) {
        BlockCable cable;
        TileEntityCable tile;
        Block block = iBlockState.func_177230_c();
        if (block instanceof BlockCable && (tile = (TileEntityCable)(cable = (BlockCable)block).getPipeTileEntity((IBlockAccess)world, iProbeHitData.getPos())) != null) {
            double averageVoltage = tile.getAverageVoltage();
            double averageAmperage = Math.round(tile.getAverageAmperage());
            double maxAmperage = tile.getMaxAmperage();
            double maxVoltage = tile.getMaxVoltage();
            double actualAverageVoltage = Math.min((double)Math.round(averageVoltage / (double)CableTileInfoProvider.getActualAmperage(averageAmperage)), maxVoltage);
            String currentAmperage = TextFormattingUtil.formatNumbers((double)averageAmperage);
            String currentMaxAmperage = TextFormattingUtil.formatNumbers((double)maxAmperage);
            String currentTier = GTValues.VNF[GTUtility.getTierByVoltage((long)((long)actualAverageVoltage))];
            String maxTier = GTValues.VNF[GTUtility.getTierByVoltage((long)((long)maxVoltage))];
            iProbeInfo.horizontal().horizontal().text(LocalizationUtils.format((String)"gregicprobe.top.pipe.energy", (Object[])new Object[]{actualAverageVoltage, currentTier, maxTier, currentAmperage, currentMaxAmperage}));
        }
    }

    public String getID() {
        return "gregicprobe:cable_info";
    }

    public static int getActualAmperage(double Amperage) {
        for (int i = 1; i < 9; ++i) {
            if (!(Amperage <= (double)(1 << 2 * i))) continue;
            return i;
        }
        return 1;
    }
}

