/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.gregicprobe.element;

import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import mcjty.theoneprobe.api.IElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidStackElement
implements IElement {
    private final String location;
    private final int color;
    private final int id;
    private final boolean showAmountText;
    private final int amount;
    private TextureAtlasSprite sprite = null;

    public FluidStackElement(int id, @NotNull FluidStack stack) {
        this(id, stack, false);
    }

    public FluidStackElement(int id, @NotNull FluidStack stack, boolean showAmountText) {
        this(id, stack.getFluid().getStill(stack), stack.getFluid().getColor(stack), stack.amount, showAmountText);
    }

    public FluidStackElement(int id, @NotNull ResourceLocation location, int color, int amount) {
        this(id, location, color, amount, false);
    }

    public FluidStackElement(int id, @NotNull ResourceLocation location, int color, int amount, boolean showAmountText) {
        this.location = location.toString();
        this.color = color;
        this.amount = amount;
        this.showAmountText = showAmountText;
        this.id = id;
    }

    public FluidStackElement(@NotNull ByteBuf buf) {
        byte[] bytes = new byte[buf.readInt()];
        buf.readBytes(bytes);
        this.location = new String(bytes, StandardCharsets.UTF_8);
        this.color = buf.readInt();
        this.amount = buf.readInt();
        this.showAmountText = buf.readBoolean();
        this.id = buf.readInt();
    }

    public void render(int x, int y) {
        String actualLocation = this.location;
        if (this.location.contains("material_sets/fluid/") && (this.location.contains("/gas") || this.location.contains("/plasma"))) {
            actualLocation = this.location.replace("material_sets/fluid/", "material_sets/dull/");
        }
        if (this.sprite == null) {
            this.sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(actualLocation);
        }
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtil.setGlColorFromInt((int)this.color, (int)255);
        RenderUtil.drawFluidTexture((double)x, (double)y, (TextureAtlasSprite)this.sprite, (int)0, (int)0, (double)0.0);
        if (this.showAmountText && this.amount > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            Minecraft minecraft = Minecraft.func_71410_x();
            String format = TextFormattingUtil.formatLongToCompactString((long)this.amount) + "L";
            minecraft.field_71466_p.func_175063_a(format, ((float)x + 5.3333335f) * 2.0f - (float)minecraft.field_71466_p.func_78256_a(format) + 21.0f, ((float)y + 5.3333335f + 6.0f) * 2.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
    }

    public int getWidth() {
        return 18;
    }

    public int getHeight() {
        return 16;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        byte[] bytes = this.location.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
        buf.writeInt(this.color);
        buf.writeInt(this.amount);
        buf.writeBoolean(this.showAmountText);
        buf.writeInt(this.id);
    }

    public int getID() {
        return this.id;
    }
}

