/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity.ai;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import vazkii.quark.base.util.MutableVectorHolder;
import vazkii.quark.world.entity.EntityStoneling;

public class EntityAIActWary
extends EntityAIWanderAvoidWater {
    private final EntityStoneling stoneling;
    private final boolean scaredBySuddenMovement;
    private final double range;
    private boolean startled;
    private final Map<EntityPlayer, MutableVectorHolder> lastPositions = new WeakHashMap<EntityPlayer, MutableVectorHolder>();
    private final Map<EntityPlayer, MutableVectorHolder> lastSpeeds = new WeakHashMap<EntityPlayer, MutableVectorHolder>();

    public EntityAIActWary(EntityStoneling stoneling, double speed, double range, boolean scaredBySuddenMovement) {
        super((EntityCreature)stoneling, speed, 1.0f);
        this.stoneling = stoneling;
        this.range = range;
        this.scaredBySuddenMovement = scaredBySuddenMovement;
    }

    private static void updateMotion(MutableVectorHolder holder, double x, double y, double z) {
        holder.x = x;
        holder.y = y;
        holder.z = z;
    }

    private static void updatePos(MutableVectorHolder holder, Entity entity) {
        holder.x = entity.field_70165_t;
        holder.y = entity.field_70163_u;
        holder.z = entity.field_70161_v;
    }

    private static MutableVectorHolder initPos(EntityPlayer p) {
        MutableVectorHolder holder = new MutableVectorHolder();
        EntityAIActWary.updatePos(holder, (Entity)p);
        return holder;
    }

    public void startle() {
        this.startled = true;
    }

    protected boolean shouldApplyPath() {
        return super.func_75250_a();
    }

    public void func_75246_d() {
        if (this.stoneling.func_70661_as().func_75500_f() && this.shouldApplyPath()) {
            this.func_75249_e();
        }
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75251_c() {
        this.stoneling.func_70661_as().func_75499_g();
    }

    public boolean func_75250_a() {
        if (this.startled || this.stoneling.isPlayerMade()) {
            return false;
        }
        List playersAround = this.stoneling.field_70170_p.func_175647_a(EntityPlayer.class, this.stoneling.func_174813_aQ().func_186662_g(this.range), player -> player != null && !player.field_71075_bZ.field_75098_d && player.func_70068_e((Entity)this.stoneling) < this.range * this.range);
        if (playersAround.isEmpty()) {
            return false;
        }
        for (EntityPlayer player2 : playersAround) {
            if (player2.func_70093_af()) {
                if (!this.scaredBySuddenMovement) continue;
                MutableVectorHolder lastSpeed = this.lastSpeeds.computeIfAbsent(player2, p -> new MutableVectorHolder());
                MutableVectorHolder lastPos = this.lastPositions.computeIfAbsent(player2, EntityAIActWary::initPos);
                double dX = player2.field_70165_t - lastPos.x;
                double dY = player2.field_70163_u - lastPos.y;
                double dZ = player2.field_70161_v - lastPos.z;
                double xDisplacement = dX - lastSpeed.x;
                double yDisplacement = dY - lastSpeed.y;
                double zDisplacement = dZ - lastSpeed.z;
                EntityAIActWary.updateMotion(lastSpeed, dX, dY, dZ);
                EntityAIActWary.updatePos(lastPos, (Entity)player2);
                double displacementSq = xDisplacement * xDisplacement + yDisplacement * yDisplacement + zDisplacement * zDisplacement;
                if (displacementSq < 0.01) {
                    return true;
                }
                this.startled = true;
                return false;
            }
            this.startled = true;
            return false;
        }
        return true;
    }
}

