/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter;

import com.google.common.eventbus.EventBus;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.transformer.Config;
import zone.rong.mixinbooter.Context;
import zone.rong.mixinbooter.IEarlyMixinLoader;
import zone.rong.mixinbooter.IMixinConfigHijacker;
import zone.rong.mixinbooter.fix.MixinFixer;
import zone.rong.mixinbooter.util.MockedArtifactVersionAdapter;
import zone.rong.mixinbooter.util.MockedMetadataCollection;

@IFMLLoadingPlugin.Name(value="MixinBooter")
@IFMLLoadingPlugin.SortingIndex(value=-2147483647)
public final class MixinBooterPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinBooter");
    private static final Map<String, String> presentMods = new HashMap<String, String>();
    private static final Map<String, IMixinConfigHijacker> configHijackers = new HashMap<String, IMixinConfigHijacker>();
    private static Field modApiManager$dataTable;

    public static IMixinConfigHijacker getHijacker(String configName) {
        return configHijackers.get(configName);
    }

    static String getMinecraftVersion() {
        return (String)FMLInjectionData.data()[4];
    }

    public MixinBooterPlugin() {
        this.addTransformationExclusions();
        this.initialize();
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return "zone.rong.mixinbooter.MixinBooterPlugin$Container";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        Object coremodList = data.get("coremodList");
        if (!(coremodList instanceof List)) {
            throw new RuntimeException("Blackboard property 'coremodList' must be of type List, early loaders were not able to be gathered");
        }
        Collection<IEarlyMixinLoader> earlyLoaders = this.gatherEarlyLoaders((List)coremodList);
        this.loadEarlyLoaders(earlyLoaders);
        this.recordConfigOwners();
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private void addTransformationExclusions() {
        Launch.classLoader.addTransformerExclusion("scala.");
        Launch.classLoader.addTransformerExclusion("com.llamalad7.mixinextras.");
    }

    private void initialize() {
        GlobalProperties.put(GlobalProperties.Keys.CLEANROOM_DISABLE_MIXIN_CONFIGS, new HashSet());
        LOGGER.info("Initializing Mixins...");
        MixinBootstrap.init();
        Mixins.addConfiguration("mixin.mixinbooter.init.json");
        LOGGER.info("Initializing MixinExtras...");
        MixinExtrasBootstrap.init();
        MixinFixer.patchAncientModMixinsLoadingMethod();
        LOGGER.info("Gathering present mods...");
        this.gatherPresentMods();
    }

    private void gatherPresentMods() {
        Gson gson = new GsonBuilder().registerTypeAdapter(ArtifactVersion.class, (Object)new MockedArtifactVersionAdapter()).setLenient().create();
        try {
            Enumeration resources = Launch.classLoader.getResources("mcmod.info");
            while (resources.hasMoreElements()) {
                String modId;
                URL url = (URL)resources.nextElement();
                String fileName = this.getJarNameFromResource(url);
                if (fileName == null || (modId = this.parseMcmodInfo(gson, url)) == null) continue;
                presentMods.put(fileName, modId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to gather present mods", e);
        }
        LOGGER.info("Finished gathering {} mods...", (Object)presentMods.size());
    }

    private String getJarNameFromResource(URL url) {
        String filePath;
        String[] parts;
        if (url.getPath().contains("!/") && (parts = (filePath = url.getPath().split("!/")[0]).split("/")).length != 0) {
            return parts[parts.length - 1];
        }
        return null;
    }

    private String parseMcmodInfo(Gson gson, URL url) {
        try {
            JsonElement root = (JsonElement)gson.fromJson((Reader)new InputStreamReader(url.openStream()), JsonElement.class);
            if (root.isJsonArray()) {
                return ((ModMetadata[])gson.fromJson((Reader)new InputStreamReader((InputStream)url.openStream()), ModMetadata[].class))[0].modId;
            }
            return ((MockedMetadataCollection)gson.fromJson((Reader)new InputStreamReader((InputStream)url.openStream()), MockedMetadataCollection.class)).modList[0].modId;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to parse mcmod.info for {}", (Object)url, (Object)t);
            return null;
        }
    }

    private Collection<IEarlyMixinLoader> gatherEarlyLoaders(List coremodList) {
        Field fmlPluginWrapper$coreModInstance = null;
        LinkedHashSet<IEarlyMixinLoader> queuedLoaders = new LinkedHashSet<IEarlyMixinLoader>();
        for (Object coremod : coremodList) {
            try {
                Object theMod;
                if (fmlPluginWrapper$coreModInstance == null) {
                    fmlPluginWrapper$coreModInstance = coremod.getClass().getField("coreModInstance");
                    fmlPluginWrapper$coreModInstance.setAccessible(true);
                }
                if ((theMod = fmlPluginWrapper$coreModInstance.get(coremod)) instanceof IMixinConfigHijacker) {
                    IMixinConfigHijacker interceptor = (IMixinConfigHijacker)theMod;
                    for (String hijacked : interceptor.getHijackedMixinConfigs()) {
                        configHijackers.put(hijacked, interceptor);
                    }
                }
                if (theMod instanceof IEarlyMixinLoader) {
                    queuedLoaders.add((IEarlyMixinLoader)theMod);
                    continue;
                }
                if (!"org.spongepowered.mod.SpongeCoremod".equals(theMod.getClass().getName())) continue;
                LOGGER.info("Registering SpongeForgeFixer transformer to solve issues pertaining SpongeForge.");
                Launch.classLoader.registerTransformer("zone.rong.mixinbooter.fix.spongeforge.SpongeForgeFixer");
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected error", t);
            }
        }
        return queuedLoaders;
    }

    private void loadEarlyLoaders(Collection<IEarlyMixinLoader> queuedLoaders) {
        for (IEarlyMixinLoader queuedLoader : queuedLoaders) {
            LOGGER.info("Loading early loader [{}] for its mixins.", (Object)queuedLoader.getClass().getName());
            for (String mixinConfig : queuedLoader.getMixinConfigs()) {
                Context context = new Context(mixinConfig, presentMods.values());
                if (!queuedLoader.shouldMixinConfigQueue(context)) continue;
                IMixinConfigHijacker hijacker = MixinBooterPlugin.getHijacker(mixinConfig);
                if (hijacker != null) {
                    LOGGER.info("Mixin configuration [{}] intercepted by [{}].", (Object)mixinConfig, (Object)hijacker.getClass().getName());
                    continue;
                }
                LOGGER.info("Adding [{}] mixin configuration.", (Object)mixinConfig);
                Mixins.addConfiguration(mixinConfig);
                queuedLoader.onMixinConfigQueued(context);
            }
        }
    }

    private void recordConfigOwners() {
        for (Config config : Mixins.getConfigs()) {
            if (config.getConfig().hasDecoration("mixinOwner")) continue;
            config.getConfig().decorate("mixinOwner", () -> this.retrieveConfigOwner(config));
        }
    }

    private String retrieveConfigOwner(Config config) {
        String modId;
        String jar;
        if (modApiManager$dataTable == null) {
            try {
                modApiManager$dataTable = ModAPIManager.class.getDeclaredField("dataTable");
                modApiManager$dataTable.setAccessible(true);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to reflectively retrieve ModAPIManager#dataTable", e);
            }
        }
        try {
            ModContainer container;
            String pkg;
            ModCandidate candidate;
            ASMDataTable table = (ASMDataTable)modApiManager$dataTable.get(ModAPIManager.INSTANCE);
            if (table != null && (candidate = (ModCandidate)table.getCandidatesFor(pkg = (pkg = config.getConfig().getMixinPackage()).charAt(pkg.length() - 1) == '.' ? pkg.substring(0, pkg.length() - 1) : pkg).stream().findFirst().orElse(null)) != null && (container = (ModContainer)candidate.getContainedMods().get(0)) != null) {
                return container.getModId();
            }
        }
        catch (IllegalAccessException table) {
            // empty catch block
        }
        URL url = Launch.classLoader.getResource(config.getName());
        if (url != null && (jar = this.getJarNameFromResource(url)) != null && (modId = presentMods.get(jar)) != null) {
            return modId;
        }
        return "unknown-owner";
    }

    public static class Container
    extends DummyModContainer {
        public Container() {
            super(new ModMetadata());
            LOGGER.info("Initializing MixinBooter's Mod Container.");
            ModMetadata meta = this.getMetadata();
            meta.modId = "mixinbooter";
            meta.name = "MixinBooter";
            meta.description = "A mod that provides the Sponge Mixin library, a standard API for mods to load mixins targeting Minecraft and other mods, and associated useful utilities on 1.8 - 1.12.2.";
            meta.credits = "Thanks to LegacyModdingMC + Fabric for providing the initial mixin fork.";
            meta.version = "10.2";
            meta.logoFile = "/icon.png";
            meta.authorList.add("Rongmario");
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }

        public Set<ArtifactVersion> getRequirements() {
            try {
                if ("1.12.2".equals(MixinBooterPlugin.getMinecraftVersion())) {
                    try {
                        return Collections.singleton(new SpongeForgeArtifactVersion());
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Collections.emptySet();
        }

        private static class SpongeForgeArtifactVersion
        extends DefaultArtifactVersion {
            public SpongeForgeArtifactVersion() throws InvalidVersionSpecificationException {
                super("spongeforge", VersionRange.createFromVersionSpec((String)"[7.4.8,)"));
            }

            public boolean containsVersion(ArtifactVersion source) {
                if (source == this) {
                    return true;
                }
                String version = source.getVersionString();
                String[] hyphenSplits = version.split("-");
                if (hyphenSplits.length > 1) {
                    version = hyphenSplits[hyphenSplits.length - 1].startsWith("RC") ? hyphenSplits[hyphenSplits.length - 2] : hyphenSplits[hyphenSplits.length - 1];
                }
                source = new DefaultArtifactVersion(source.getLabel(), version);
                return super.containsVersion(source);
            }
        }
    }
}

