/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import com.llamalad7.mixinextras.lib.gson.Strictness;
import com.llamalad7.mixinextras.lib.gson.stream.JsonReader;
import com.llamalad7.mixinextras.lib.semver.Version;
import com.llamalad7.mixinextras.service.MixinExtrasVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.WeakHashMap;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.service.MixinService;

public class MixinConfigUtils {
    public static final String KEY_MIN_VERSION = "minMixinExtrasVersion";
    private static final Map<IMixinConfig, MixinExtrasVersion> MIN_CACHE = new WeakHashMap<IMixinConfig, MixinExtrasVersion>();

    public static MixinExtrasVersion minVersionFor(IMixinConfig config) {
        return MIN_CACHE.computeIfAbsent(config, k -> {
            Version min = MixinConfigUtils.readMin(config);
            MixinExtrasVersion[] versions = MixinExtrasVersion.values();
            if (min == null) {
                return versions[0];
            }
            if (min.isHigherThan(MixinExtrasVersion.LATEST.getSemver())) {
                throw new IllegalArgumentException(String.format("Mixin Config %s requires MixinExtras >=%s but %s is present!", new Object[]{config.getName(), min, MixinExtrasVersion.LATEST}));
            }
            MixinExtrasVersion result = versions[0];
            for (MixinExtrasVersion version : versions) {
                if (version.getSemver().isHigherThan(min)) break;
                result = version;
            }
            return result;
        });
    }

    private static Version readMin(IMixinConfig config) {
        return MixinConfigUtils.readConfig(config, reader -> {
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals(KEY_MIN_VERSION)) {
                    String ver = reader.nextString();
                    return Version.tryParse(ver).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not valid SemVer!", ver)));
                }
                reader.skipValue();
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readConfig(IMixinConfig config, JsonProcessor<T> compute) {
        try (JsonReader reader = new JsonReader(new InputStreamReader(MixinService.getService().getResourceAsStream(config.getName())));){
            reader.setStrictness(Strictness.LENIENT);
            T t = compute.process(reader);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read mixin config " + config.getName(), e);
        }
    }

    @FunctionalInterface
    private static interface JsonProcessor<T> {
        public T process(JsonReader var1) throws IOException;
    }
}

