/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.scalinghealth.config.Config;

public class EntityDifficultyChangeList {
    private Map<String, DifficultyChanges> map = new HashMap<String, DifficultyChanges>();

    @Nonnull
    public DifficultyChanges get(Entity entity) {
        ResourceLocation resource = EntityList.func_191301_a((Entity)entity);
        if (resource == null) {
            return this.defaultValues(entity);
        }
        String id = resource.toString();
        String idOld = EntityList.func_75621_b((Entity)entity);
        for (Map.Entry<String, DifficultyChanges> entry : this.map.entrySet()) {
            String key = entry.getKey();
            if (!key.equalsIgnoreCase(id) && !key.equalsIgnoreCase(idOld) && !key.equalsIgnoreCase("minecraft:" + id)) continue;
            return entry.getValue();
        }
        return this.defaultValues(entity);
    }

    public void put(String entityId, float onStandardKill, float onBlightKill) {
        this.map.put(entityId, new DifficultyChanges(onStandardKill, onBlightKill));
    }

    public void clear() {
        this.map.clear();
    }

    public DifficultyChanges defaultValues(Entity entity) {
        boolean isBoss;
        boolean bl = isBoss = !entity.func_184222_aU();
        return new DifficultyChanges(isBoss ? Config.Difficulty.perBossKill : (entity instanceof IMob ? Config.Difficulty.perHostileKill : Config.Difficulty.perPassiveKill), Config.Difficulty.perBlightKill + (isBoss ? Config.Difficulty.perBossKill : 0.0f));
    }

    public static class DifficultyChanges {
        public final float onStandardKill;
        public final float onBlightKill;

        public DifficultyChanges(float standard, float blight) {
            this.onStandardKill = standard;
            this.onBlightKill = blight;
        }
    }
}

