/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.lib;

import java.util.Optional;

public final class SimpleExpression {
    private final Operation operation;
    private final float value;

    private SimpleExpression(String str) {
        char c = str.charAt(0);
        this.operation = c == '*' || c == 'x' ? Operation.MUL : (c == '/' ? Operation.DIV : (c == '-' ? Operation.SUB : Operation.ADD));
        this.value = Float.parseFloat(str.substring(1));
    }

    public static Optional<SimpleExpression> from(String str) {
        try {
            return Optional.of(new SimpleExpression(str));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public double apply(double value) {
        switch (this.operation) {
            case ADD: {
                return value + (double)this.value;
            }
            case SUB: {
                return value - (double)this.value;
            }
            case MUL: {
                return value * (double)this.value;
            }
            case DIV: {
                return value / (double)this.value;
            }
        }
        return value;
    }

    private static enum Operation {
        ADD,
        SUB,
        MUL,
        DIV;

    }
}

