/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.entity.EntityBlightFire;
import net.silentchaos512.scalinghealth.event.BlightHandler;
import net.silentchaos512.scalinghealth.event.DifficultyHandler;
import net.silentchaos512.scalinghealth.event.PlayerBonusRegenHandler;
import net.silentchaos512.scalinghealth.lib.EnumAreaDifficultyMode;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="scalinghealth", value={Side.CLIENT})
public final class ScalingHealthClientEvents {
    private static final float DEBUG_TEXT_SCALE = 0.6f;

    private ScalingHealthClientEvents() {
    }

    @SubscribeEvent
    public static void renderTick(RenderGameOverlayEvent.Post event) {
        if (Config.Debug.debugMode && Config.Debug.debugOverlay && Minecraft.func_71410_x().field_71441_e != null && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
            GL11.glPushMatrix();
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)1.0f);
            String text = ScalingHealthClientEvents.getDebugText();
            int y = 3;
            for (String line : text.split("\n")) {
                String[] array = line.split("=");
                if (array.length == 2) {
                    fontRender.func_78276_b(array[0].trim(), 3, y, 0xFFFFFF);
                    fontRender.func_78276_b(array[1].trim(), 100, y, 0xFFFFFF);
                } else {
                    fontRender.func_78276_b(line, 3, y, 0xFFFFFF);
                }
                y += 10;
            }
            GL11.glPopMatrix();
        }
    }

    private static String getDebugText() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
        EnumAreaDifficultyMode areaMode = Config.Difficulty.AREA_DIFFICULTY_MODE;
        if (data == null) {
            return "Player data is null!";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("Area Difficulty = %.4f (%s)\n", areaMode.getAreaDifficulty((World)world, player.func_180425_c()), areaMode.name()));
        ret.append(String.format("Player Difficulty = %.4f\n", data.getDifficulty()));
        ret.append("Player Health = ").append(player.func_110143_aJ()).append(" / ").append(player.func_110138_aP()).append("\n");
        IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (!attr.func_111122_c().isEmpty()) {
            for (AttributeModifier mod : attr.func_111122_c()) {
                ret.append("         ").append(mod).append("\n");
            }
        } else {
            ret.append("        No modifiers! That should not happen.\n");
        }
        int regenTimer = PlayerBonusRegenHandler.getTimerForPlayer((EntityPlayer)player);
        ret.append(String.format("Regen Timer = %d (%ds)", regenTimer, regenTimer / 20)).append("\n");
        ret.append(String.format("Food = %d (%.2f)", player.func_71024_bL().func_75116_a(), Float.valueOf(player.func_71024_bL().func_75115_e()))).append("\n");
        int blightCount = world.func_175644_a(EntityLivingBase.class, BlightHandler::isBlight).size();
        int blightFires = world.func_175644_a(EntityBlightFire.class, e -> true).size();
        ret.append(String.format("Blights (Fires) = %d (%d)", blightCount, blightFires)).append("\n");
        int mobsProcessed = DifficultyHandler.debugGetMobsProcessed();
        float mobsProcessedRate = DifficultyHandler.debugGetMobsProcessedRate();
        ret.append(String.format("Mobs processed = %d (%.1f/s avg)", mobsProcessed, Float.valueOf(mobsProcessedRate))).append("\n");
        return ret.toString();
    }
}

