/*
 * Decompiled with CFR 0.152.
 */
package com.github.upcraftlp.inhaler;

import com.github.upcraftlp.inhaler.GaspunkInhaler;
import com.github.upcraftlp.inhaler.api.IEntityGasEffect;
import com.github.upcraftlp.inhaler.capability.CapabilityGasEffect;
import com.google.common.collect.Lists;
import java.util.List;
import ladysnake.gaspunk.api.IBreathingHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="gp_inhaler")
public class InhalerHandler {
    @CapabilityInject(value=IBreathingHandler.class)
    public static final Capability<IBreathingHandler> CAPABILITY_BREATHING = null;
    private static IRecipe EMPTY_INHALER_RECIPE;
    private static IRecipe INHALER_RECIPE;
    private static int OREDICT_ID_IRON_INGOT;

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.func_70613_aW()) {
            return;
        }
        IEntityGasEffect effect = (IEntityGasEffect)player.getCapability(CapabilityGasEffect.GAS_EFFECT_CAPABILITY, null);
        effect.applyEffects((EntityLivingBase)player, (IBreathingHandler)player.getCapability(CAPABILITY_BREATHING, null));
    }

    @SubscribeEvent
    public static void initCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("gp_inhaler", "gas_effect"), (ICapabilityProvider)new CapabilityGasEffect());
        }
    }

    @SubscribeEvent
    public static void onCraftingIron(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            RecipeBookServer recipeBook = ((EntityPlayerMP)event.player).func_192037_E();
            if (recipeBook.func_193830_f(EMPTY_INHALER_RECIPE) && recipeBook.func_193830_f(INHALER_RECIPE)) {
                return;
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)event.smelting)) {
                if (id != OREDICT_ID_IRON_INGOT) continue;
                event.player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{EMPTY_INHALER_RECIPE, INHALER_RECIPE}));
                if (!GaspunkInhaler.isDebugMode()) continue;
                GaspunkInhaler.getLogger().info("Player {} has unlocked the inhaler recipes!", (Object)event.player.getDisplayNameString());
            }
        }
    }

    static void init() {
        OREDICT_ID_IRON_INGOT = OreDictionary.getOreID((String)"ingotIron");
        EMPTY_INHALER_RECIPE = CraftingManager.func_193373_a((ResourceLocation)new ResourceLocation("gp_inhaler", "empty_inhaler"));
        INHALER_RECIPE = CraftingManager.func_193373_a((ResourceLocation)new ResourceLocation("gp_inhaler", "inhaler"));
        if (GaspunkInhaler.isDebugMode()) {
            GaspunkInhaler.getLogger().info("Ore Dictionary ID of \"ingotIron\": {}", (Object)OREDICT_ID_IRON_INGOT);
        }
    }

    static {
        OREDICT_ID_IRON_INGOT = -1;
    }
}

