/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevator;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xyz.vsngamer.elevator.init.ModConfig;
import xyz.vsngamer.elevator.network.NetworkHandler;
import xyz.vsngamer.elevator.network.TeleportHandler;
import xyz.vsngamer.elevator.network.TeleportRequest;

@SideOnly(value=Side.CLIENT)
public class ElevatorHandler {
    private static boolean lastSneaking;
    private static boolean lastJumping;

    @SubscribeEvent
    public void onInput(InputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!player.func_175149_v()) {
            boolean jumping;
            boolean sneaking = player.func_70093_af();
            if (lastSneaking != sneaking) {
                lastSneaking = sneaking;
                if (sneaking) {
                    ElevatorHandler.tryTeleport((EntityPlayer)player, EnumFacing.DOWN);
                }
            }
            if (lastJumping != (jumping = player.field_71158_b.field_78901_c)) {
                lastJumping = jumping;
                if (jumping) {
                    ElevatorHandler.tryTeleport((EntityPlayer)player, EnumFacing.UP);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void tryTeleport(EntityPlayer player, EnumFacing facing) {
        World world = player.field_70170_p;
        IBlockState fromState = null;
        BlockPos fromPos = new BlockPos(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
        boolean elevator = false;
        for (int i = 0; i <= 2 && !(elevator = TeleportHandler.isElevator(fromState = world.func_180495_p(fromPos))); ++i) {
            fromPos = fromPos.func_177977_b();
        }
        if (!elevator) {
            return;
        }
        BlockPos.MutableBlockPos toPos = new BlockPos.MutableBlockPos(fromPos);
        while (true) {
            toPos.func_185336_p(toPos.func_177956_o() + facing.func_96559_d());
            if (Math.abs(toPos.func_177956_o() - fromPos.func_177956_o()) > ModConfig.getClientConfig().range) return;
            IBlockState toState = world.func_180495_p((BlockPos)toPos);
            if (!TeleportHandler.isElevator(toState)) continue;
            if (TeleportHandler.validateTarget((IBlockAccess)world, (BlockPos)toPos)) {
                if (ModConfig.getClientConfig().sameColor && fromState.func_177230_c() != toState.func_177230_c()) continue;
                NetworkHandler.networkWrapper.sendToServer((IMessage)new TeleportRequest(fromPos, (BlockPos)toPos));
                return;
            }
            if (!ModConfig.getClientConfig().skipUnreachable) return;
        }
    }
}

