/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.EntityCountDump;
import fi.dy.masa.tellme.util.chunkprocessor.ChunkProcessorLoadedChunks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EntitiesLister
extends ChunkProcessorLoadedChunks {
    private List<Entity> entities = new ArrayList<Entity>();
    private int totalCount;

    @Override
    public void processChunk(Chunk chunk) {
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        int total = 0;
        for (int i = 0; i < entityLists.length; ++i) {
            Iterator iter = entityLists[i].iterator();
            while (iter.hasNext()) {
                this.entities.add((Entity)iter.next());
            }
            total += entityLists[i].size();
        }
        if (total == 0) {
            ++this.chunksWithZeroCount;
        } else {
            this.totalCount += total;
        }
    }

    @Override
    public EntityCountDump createDump(World world) {
        EntityCountDump dump = new EntityCountDump(5);
        dump.addTitle("Name", "Health", "Location", "Chunk", "Region");
        dump.addHeader("All currently loaded entities:");
        dump.setColumnAlignment(1, DataDump.Alignment.RIGHT);
        dump.setSort(true);
        for (Entity entity : this.entities) {
            BlockPos pos = entity.func_180425_c();
            dump.addData(entity.func_70005_c_(), entity instanceof EntityLivingBase ? String.format("%.2f", Float.valueOf(((EntityLivingBase)entity).func_110143_aJ())) : "-", String.format("x = %8.2f, y = %8.2f, z = %8.2f", entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), String.format("[%5d, %5d]", pos.func_177958_n() >> 4, pos.func_177952_p() >> 4), String.format("r.%d.%d", pos.func_177958_n() >> 9, pos.func_177952_p() >> 9));
        }
        dump.addFooter(String.format("In total there were %d loaded entities in %d chunks.", this.totalCount, this.getLoadedChunkCount() - this.chunksWithZeroCount));
        return dump;
    }
}

