/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import fi.dy.masa.tellme.util.WorldUtils;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ChunkProcessorAllChunks {
    private boolean areCoordinatesValid(BlockPos pos1, BlockPos pos2) throws CommandException {
        if (pos1.func_177956_o() < 0 || pos2.func_177956_o() < 0) {
            throw new WrongUsageException("Argument(s) out of range: y < 0", new Object[0]);
        }
        if (pos1.func_177956_o() > 255 || pos2.func_177956_o() > 255) {
            throw new WrongUsageException("Argument(s) out of range: y > 255", new Object[0]);
        }
        if (pos1.func_177958_n() < -30000000 || pos2.func_177958_n() < -30000000 || pos1.func_177952_p() < -30000000 || pos2.func_177952_p() < -30000000) {
            throw new WrongUsageException("Argument(s) out of range (world limits): x or z < -30M", new Object[0]);
        }
        if (pos1.func_177958_n() > 30000000 || pos2.func_177958_n() > 30000000 || pos1.func_177952_p() > 30000000 || pos2.func_177952_p() > 30000000) {
            throw new WrongUsageException("Argument(s) out of range (world limits): x or z > 30M", new Object[0]);
        }
        return true;
    }

    private Pair<BlockPos, BlockPos> getCorners(BlockPos pos1, BlockPos pos2) {
        int xMin = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        int yMin = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int zMin = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        int xMax = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
        int yMax = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
        int zMax = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
        yMin = MathHelper.func_76125_a((int)yMin, (int)0, (int)255);
        yMax = MathHelper.func_76125_a((int)yMax, (int)0, (int)255);
        return Pair.of((Object)new BlockPos(xMin, yMin, zMin), (Object)new BlockPos(xMax, yMax, zMax));
    }

    public void processChunks(World world, BlockPos playerPos, int rangeX, int rangeY, int rangeZ) throws CommandException {
        BlockPos pos1 = playerPos.func_177982_a(-rangeX, -rangeY, -rangeZ);
        BlockPos pos2 = playerPos.func_177982_a(rangeX, rangeY, rangeZ);
        this.processChunks(world, pos1, pos2);
    }

    public void processChunks(World world, BlockPos pos1, BlockPos pos2) throws CommandException {
        BlockPos posMax;
        Pair<BlockPos, BlockPos> pair = this.getCorners(pos1, pos2);
        BlockPos posMin = (BlockPos)pair.getLeft();
        if (!this.areCoordinatesValid(posMin, posMax = (BlockPos)pair.getRight())) {
            throw new WrongUsageException("Invalid coordinate(s) in the range, aborting", new Object[0]);
        }
        ChunkPos chunkPosMin = new ChunkPos(posMin.func_177958_n() >> 4, posMin.func_177952_p() >> 4);
        ChunkPos chunkPosMax = new ChunkPos(posMax.func_177958_n() >> 4, posMax.func_177952_p() >> 4);
        List<Chunk> chunks = WorldUtils.loadAndGetChunks(world, chunkPosMin, chunkPosMax);
        this.processChunks(chunks, posMin, posMax);
    }

    public void processChunks(Collection<Chunk> chunks) {
        this.processChunks(chunks, new BlockPos(-30000000, 0, -30000000), new BlockPos(30000000, 255, 30000000));
    }

    public abstract void processChunks(Collection<Chunk> var1, BlockPos var2, BlockPos var3);
}

