/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util.chunkprocessor;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeStats {
    private final Object2LongOpenHashMap<Biome> biomeCounts = new Object2LongOpenHashMap();
    private int totalCount;
    private boolean append;

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void getFullBiomeDistribution(BiomeProvider biomeProvider, BlockPos posMin, BlockPos posMax) {
        Object2LongOpenHashMap counts = new Object2LongOpenHashMap();
        long timeBefore = System.currentTimeMillis();
        long count = 0L;
        int chunkMinX = posMin.func_177958_n() >> 4;
        int chunkMinZ = posMin.func_177952_p() >> 4;
        int chunkMaxX = posMax.func_177958_n() >> 4;
        int chunkMaxZ = posMax.func_177952_p() >> 4;
        Biome[] biomes = new Biome[256];
        for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
            for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
                int xMin = Math.max(chunkX << 4, posMin.func_177958_n());
                int zMin = Math.max(chunkZ << 4, posMin.func_177952_p());
                int xMax = Math.min((chunkX << 4) + 15, posMax.func_177958_n());
                int zMax = Math.min((chunkZ << 4) + 15, posMax.func_177952_p());
                int width = xMax - xMin + 1;
                int length = zMax - zMin + 1;
                biomeProvider.func_76931_a(biomes, xMin, zMin, width, length, false);
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < length; ++z) {
                        counts.addTo((Object)biomes[x * length + z], 1L);
                    }
                }
                count += (long)(width * length);
            }
        }
        long timeAfter = System.currentTimeMillis();
        TellMe.logger.info(String.format(Locale.US, "Counted the biome for %d xz-locations in %.3f seconds", count, Float.valueOf((float)(timeAfter - timeBefore) / 1000.0f)));
        this.addData((Object2LongOpenHashMap<Biome>)counts, count);
    }

    public void getSampledBiomeDistribution(BiomeProvider biomeProvider, int centerX, int centerZ, int sampleInterval, int sampleRadius) {
        Object2LongOpenHashMap counts = new Object2LongOpenHashMap();
        long timeBefore = System.currentTimeMillis();
        long count = 0L;
        int endX = centerX + sampleRadius * sampleInterval;
        int endZ = centerZ + sampleRadius * sampleInterval;
        Biome[] biomes = new Biome[1];
        for (int z = centerZ - sampleRadius * sampleInterval; z <= endZ; z += sampleInterval) {
            for (int x = centerX - sampleRadius * sampleInterval; x <= endX; x += sampleInterval) {
                biomeProvider.func_76931_a(biomes, x, z, 1, 1, false);
                counts.addTo((Object)biomes[0], 1L);
                ++count;
            }
        }
        long timeAfter = System.currentTimeMillis();
        TellMe.logger.info(String.format(Locale.US, "Counted the biome for %d xz-locations in %.3f seconds", count, Float.valueOf((float)(timeAfter - timeBefore) / 1000.0f)));
        this.addData((Object2LongOpenHashMap<Biome>)counts, count);
    }

    private void addData(Object2LongOpenHashMap<Biome> counts, long count) {
        if (!this.append) {
            this.biomeCounts.clear();
            this.totalCount = 0;
        }
        for (Map.Entry entry : counts.entrySet()) {
            if (this.append) {
                this.biomeCounts.addTo(entry.getKey(), ((Long)entry.getValue()).longValue());
                continue;
            }
            this.biomeCounts.put(entry.getKey(), ((Long)entry.getValue()).longValue());
        }
        this.totalCount = (int)((long)this.totalCount + count);
    }

    private void addFilteredData(DataDump dump, List<String> filters) {
        block0: for (String filter : filters) {
            ResourceLocation key;
            Biome biome;
            int firstSemi = filter.indexOf(":");
            if (firstSemi == -1) {
                filter = "minecraft:" + filter;
            }
            if ((biome = (Biome)ForgeRegistries.BIOMES.getValue(key = new ResourceLocation(filter))) == null) {
                TellMe.logger.warn("Invalid biome name '{}'", (Object)filter);
                continue;
            }
            for (Map.Entry entry : this.biomeCounts.entrySet()) {
                if (entry.getKey() != biome) continue;
                int id = Biome.func_185362_a((Biome)biome);
                long count = (Long)entry.getValue();
                dump.addData(key.toString(), TellMe.proxy.getBiomeName(biome), String.valueOf(id), String.valueOf(count), String.format("%.2f %%", (double)count * 100.0 / (double)this.totalCount));
                continue block0;
            }
        }
    }

    public List<String> queryAll(DataDump.Format format) {
        return this.query(format, null);
    }

    public List<String> query(DataDump.Format format, @Nullable List<String> filters) {
        DataDump dump = new DataDump(5, format);
        if (filters != null) {
            this.addFilteredData(dump, filters);
        } else {
            for (Map.Entry entry : this.biomeCounts.entrySet()) {
                Biome biome = (Biome)entry.getKey();
                if (biome == null) {
                    TellMe.logger.warn("Null biome '{}' with count {} ?!", (Object)biome, entry.getValue());
                    continue;
                }
                ResourceLocation key = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
                int id = Biome.func_185362_a((Biome)biome);
                long count = (Long)entry.getValue();
                dump.addData(key != null ? key.toString() : "<null>", TellMe.proxy.getBiomeName(biome), String.valueOf(id), String.valueOf(count), String.format("%.2f", (double)count * 100.0 / (double)this.totalCount));
            }
        }
        dump.addTitle("Registry name", "Name", "ID", "Count", "%");
        dump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
        dump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        dump.setColumnProperties(4, DataDump.Alignment.RIGHT, true);
        dump.setUseColumnSeparator(true);
        return dump.getLines();
    }
}

