/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RayTraceUtils {
    @Nonnull
    public static RayTraceResult getRayTraceFromEntity(World worldIn, Entity entityIn, boolean useLiquids) {
        double reach = 5.0;
        if (entityIn instanceof EntityPlayer) {
            reach = ((EntityPlayer)entityIn).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        }
        return RayTraceUtils.getRayTraceFromEntity(worldIn, entityIn, useLiquids, reach);
    }

    @Nonnull
    public static RayTraceResult getRayTraceFromEntity(World worldIn, Entity entityIn, boolean useLiquids, double range) {
        Vec3d rangedLookRot;
        Vec3d lookVec;
        Vec3d eyesVec = new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v);
        RayTraceResult result = worldIn.func_147447_a(eyesVec, lookVec = eyesVec.func_178787_e(rangedLookRot = entityIn.func_70676_i(1.0f).func_186678_a(range)), useLiquids, false, false);
        if (result == null) {
            result = new RayTraceResult(RayTraceResult.Type.MISS, Vec3d.field_186680_a, EnumFacing.UP, BlockPos.field_177992_a);
        }
        AxisAlignedBB bb = entityIn.func_174813_aQ().func_72321_a(rangedLookRot.field_72450_a, rangedLookRot.field_72448_b, rangedLookRot.field_72449_c).func_72321_a(1.0, 1.0, 1.0);
        List list = worldIn.func_72839_b(entityIn, bb);
        double closest = result.field_72313_a == RayTraceResult.Type.BLOCK ? eyesVec.func_72438_d(result.field_72307_f) : Double.MAX_VALUE;
        RayTraceResult entityTrace = null;
        Entity targetEntity = null;
        for (int i = 0; i < list.size(); ++i) {
            double distance;
            Entity entity = (Entity)list.get(i);
            bb = entity.func_174813_aQ();
            RayTraceResult traceTmp = bb.func_72327_a(lookVec, eyesVec);
            if (traceTmp == null || !((distance = eyesVec.func_72438_d(traceTmp.field_72307_f)) <= closest)) continue;
            targetEntity = entity;
            entityTrace = traceTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new RayTraceResult(targetEntity, entityTrace.field_72307_f);
        }
        return result;
    }
}

