/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.util;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeLocator {
    private final Object2ObjectOpenHashMap<Biome, BlockPos> biomePositions = new Object2ObjectOpenHashMap();
    private BlockPos center = BlockPos.field_177992_a;
    private int count;
    private boolean append;

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void findClosestBiomePositions(BiomeProvider biomeProvider, BlockPos center, int sampleInterval, int maxRadius) {
        long timeBefore = System.currentTimeMillis();
        int totalBiomes = ForgeRegistries.BIOMES.getKeys().size();
        Biome[] biomes = new Biome[1];
        this.count = 0;
        this.center = center;
        if (!this.append) {
            this.biomePositions.clear();
        }
        for (int radius = 0; radius <= maxRadius; ++radius) {
            int offset = radius * sampleInterval;
            if (this.samplePositionsOnRing(center.func_177958_n(), center.func_177952_p(), offset, sampleInterval, totalBiomes, biomeProvider, biomes)) break;
        }
        long timeAfter = System.currentTimeMillis();
        TellMe.logger.info(String.format(Locale.US, "Sampled the biome in %d xz-locations in %.3f seconds", this.count, Float.valueOf((float)(timeAfter - timeBefore) / 1000.0f)));
    }

    private boolean samplePositionsOnRing(int centerX, int centerZ, int offset, int sampleInterval, int totalBiomes, BiomeProvider biomeProvider, Biome[] biomes) {
        int z;
        int x;
        int minX = centerX - offset;
        int minZ = centerZ - offset;
        int maxX = centerX + offset;
        int maxZ = centerZ + offset;
        for (x = minX; x <= maxX; x += sampleInterval) {
            if (!this.samplePosition(x, minZ, totalBiomes, biomeProvider, biomes)) continue;
            return true;
        }
        for (z = minZ + sampleInterval; z <= maxZ; z += sampleInterval) {
            if (!this.samplePosition(maxZ, z, totalBiomes, biomeProvider, biomes)) continue;
            return true;
        }
        for (x = maxX - sampleInterval; x >= minX; x -= sampleInterval) {
            if (!this.samplePosition(x, maxZ, totalBiomes, biomeProvider, biomes)) continue;
            return true;
        }
        for (z = maxZ - sampleInterval; z > minZ; z -= sampleInterval) {
            if (!this.samplePosition(minX, z, totalBiomes, biomeProvider, biomes)) continue;
            return true;
        }
        return false;
    }

    private boolean samplePosition(int x, int z, int totalBiomes, BiomeProvider biomeProvider, Biome[] biomes) {
        biomeProvider.func_76931_a(biomes, x, z, 1, 1, false);
        ++this.count;
        if (!this.biomePositions.containsKey((Object)biomes[0])) {
            this.biomePositions.put((Object)biomes[0], (Object)new BlockPos(x, 0, z));
            if (this.biomePositions.size() >= totalBiomes) {
                return true;
            }
        }
        return false;
    }

    public List<String> getClosestBiomePositions(DataDump.Format format) {
        DataDump dump = new DataDump(3, format);
        for (Map.Entry entry : this.biomePositions.entrySet()) {
            Biome biome = (Biome)entry.getKey();
            if (biome == null) {
                TellMe.logger.warn("Null biome '{}' with position {} ?!", (Object)biome, entry.getValue());
                continue;
            }
            ResourceLocation key = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
            dump.addData(key != null ? key.toString() : "<null>", TellMe.proxy.getBiomeName(biome), String.format("x = %5d, z = %5d", ((BlockPos)entry.getValue()).func_177958_n(), ((BlockPos)entry.getValue()).func_177952_p()));
        }
        dump.addTitle("Registry name", "Name", "Closest location");
        dump.addHeader(String.format("Closest found biome locations around the center point x = %d, z = %d", this.center.func_177958_n(), this.center.func_177952_p()));
        dump.setUseColumnSeparator(true);
        return dump.getLines();
    }
}

