/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.event.datalogging;

import fi.dy.masa.tellme.datadump.DataDump;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class DataEntry {

    public static class DataEntryEntityEvent
    extends DataEntryBase<Vec3d> {
        private final String entityName;

        public DataEntryEntityEvent(Entity entity) {
            super(entity.func_130014_f_(), entity.func_174791_d());
            this.entityName = entity.func_70005_c_();
        }

        @Override
        protected String getDisplayName() {
            return "Entity Join World";
        }

        @Override
        public String getPrintLine() {
            Vec3d pos = (Vec3d)this.getPosition();
            return String.format("%s ; DIM: %3d, Tick: %d, Time: %d, Pos: [%.2f, %.2f, %.2f]", this.getDisplayName(), this.getDimension(), this.getWorldTick(), this.getSystemTime(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }

        @Override
        public DataDump createDataDump(DataDump.Format format) {
            DataDump dump = new DataDump(4, format);
            dump.addTitle("World tick", "System time", "Position", "Name");
            dump.setColumnProperties(0, DataDump.Alignment.RIGHT, true);
            dump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
            dump.setUseColumnSeparator(true);
            return dump;
        }

        @Override
        public void addDataToDump(DataDump dump) {
            Vec3d pos = (Vec3d)this.getPosition();
            dump.addData(String.valueOf(this.getWorldTick()), String.valueOf(this.getSystemTime()), String.format("%.2f, %.2f, %.2f", pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), this.entityName);
        }
    }

    public static class DataEntryChunkEventUnload
    extends DataEntryChunkEventBase {
        public DataEntryChunkEventUnload(Chunk chunk) {
            super(chunk);
        }

        @Override
        protected String getDisplayName() {
            return "Chunk Unload";
        }
    }

    public static class DataEntryChunkEventLoad
    extends DataEntryChunkEventBase {
        public DataEntryChunkEventLoad(Chunk chunk) {
            super(chunk);
        }

        @Override
        protected String getDisplayName() {
            return "Chunk Load";
        }
    }

    public static abstract class DataEntryChunkEventBase
    extends DataEntryBase<ChunkPos> {
        public DataEntryChunkEventBase(Chunk chunk) {
            super(chunk.func_177412_p(), chunk.func_76632_l());
        }

        @Override
        public String getPrintLine() {
            ChunkPos pos = (ChunkPos)this.getPosition();
            return String.format("%13s ; DIM: %5d, Tick: %9d, Time: %11d, ChunkPos: [%5d, %5d]", this.getDisplayName(), this.getDimension(), this.getWorldTick(), this.getSystemTime(), pos.field_77276_a, pos.field_77275_b);
        }

        @Override
        public DataDump createDataDump(DataDump.Format format) {
            DataDump dump = new DataDump(3, format);
            dump.addTitle("World tick", "System time", "Chunk");
            dump.setColumnProperties(0, DataDump.Alignment.RIGHT, true);
            dump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
            dump.setUseColumnSeparator(true);
            return dump;
        }

        @Override
        public void addDataToDump(DataDump dump) {
            ChunkPos pos = (ChunkPos)this.getPosition();
            dump.addData(String.valueOf(this.getWorldTick()), String.valueOf(this.getSystemTime()), String.format("[%5d, %5d]", pos.field_77276_a, pos.field_77275_b));
        }
    }

    public static abstract class DataEntryBase<P> {
        private final int dimension;
        private final long worldTick;
        private final long systemTime;
        private final P position;

        private DataEntryBase(World world, P position) {
            this.dimension = world.field_73011_w.getDimension();
            this.worldTick = world.func_82737_E();
            this.systemTime = System.currentTimeMillis();
            this.position = position;
        }

        public int getDimension() {
            return this.dimension;
        }

        public long getWorldTick() {
            return this.worldTick;
        }

        public long getSystemTime() {
            return this.systemTime;
        }

        public P getPosition() {
            return this.position;
        }

        protected abstract String getDisplayName();

        public abstract String getPrintLine();

        public abstract DataDump createDataDump(DataDump.Format var1);

        public abstract void addDataToDump(DataDump var1);
    }
}

